/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.security.KeyPair;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class SftpConfiguration
extends RemoteFileConfiguration {
    public static final int DEFAULT_SFTP_PORT = 22;
    @UriParam(label="security", secret=true)
    private String knownHostsFile;
    @UriParam(label="security", defaultValue="true")
    private boolean useUserKnownHostsFile = true;
    @UriParam(label="security", defaultValue="false")
    private boolean autoCreateKnownHostsFile;
    @UriParam(label="security", secret=true)
    @Metadata(supportFileReference=true)
    private String knownHostsUri;
    @UriParam(label="security", secret=true)
    private byte[] knownHosts;
    @UriParam(label="security", secret=true)
    private String privateKeyFile;
    @UriParam(label="security", secret=true)
    @Metadata(supportFileReference=true)
    private String privateKeyUri;
    @UriParam(label="security", secret=true)
    private byte[] privateKey;
    @UriParam(label="security", secret=true)
    private String privateKeyPassphrase;
    @UriParam(label="security", secret=true)
    private KeyPair keyPair;
    @UriParam(defaultValue="no", enums="no,yes", label="security")
    private String strictHostKeyChecking = "no";
    @UriParam(label="advanced")
    private int serverAliveInterval;
    @UriParam(defaultValue="1", label="advanced")
    private int serverAliveCountMax = 1;
    @UriParam(label="producer,advanced")
    private String chmod;
    @UriParam(label="security")
    private String ciphers;
    @UriParam(label="advanced")
    private int compression;
    @UriParam(label="security")
    private String preferredAuthentications;
    @UriParam(defaultValue="WARN", enums="DEBUG,INFO,WARN,ERROR")
    private LoggingLevel jschLoggingLevel = LoggingLevel.WARN;
    @UriParam(label="advanced")
    private Integer bulkRequests;
    @UriParam(label="advanced")
    private String bindAddress;
    @UriParam(label="advanced", defaultValue="true")
    private boolean existDirCheckUsingLs = true;
    @UriParam(label="security")
    private String keyExchangeProtocols;
    @UriParam(label="producer,advanced")
    private String chmodDirectory;
    @UriParam(label="security")
    private String serverHostKeys;
    @UriParam(label="security")
    private String publicKeyAcceptedAlgorithms;
    @UriParam(label="advanced")
    private String filenameEncoding;
    @UriParam(label="advanced", defaultValue="DEBUG")
    private LoggingLevel serverMessageLoggingLevel = LoggingLevel.DEBUG;

    public SftpConfiguration() {
        this.setProtocol("sftp");
    }

    public SftpConfiguration(URI uri) {
        super(uri);
    }

    @Override
    protected void setDefaultPort() {
        this.setPort(22);
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    public String getKnownHostsUri() {
        return this.knownHostsUri;
    }

    public boolean isUseUserKnownHostsFile() {
        return this.useUserKnownHostsFile;
    }

    public void setUseUserKnownHostsFile(boolean useUserKnownHostsFile) {
        this.useUserKnownHostsFile = useUserKnownHostsFile;
    }

    public boolean isAutoCreateKnownHostsFile() {
        return this.autoCreateKnownHostsFile;
    }

    public void setAutoCreateKnownHostsFile(boolean autoCreateKnownHostsFile) {
        this.autoCreateKnownHostsFile = autoCreateKnownHostsFile;
    }

    public void setKnownHostsUri(String knownHostsUri) {
        this.knownHostsUri = knownHostsUri;
    }

    public byte[] getKnownHosts() {
        return this.knownHosts;
    }

    public void setKnownHosts(byte[] knownHosts) {
        this.knownHosts = knownHosts;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getPrivateKeyUri() {
        return this.privateKeyUri;
    }

    public void setPrivateKeyUri(String privateKeyUri) {
        this.privateKeyUri = privateKeyUri;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public void setPrivateKeyPassphrase(String privateKeyFilePassphrase) {
        this.privateKeyPassphrase = privateKeyFilePassphrase;
    }

    @Deprecated
    public String getPrivateKeyFilePassphrase() {
        return this.privateKeyPassphrase;
    }

    @Deprecated
    public void setPrivateKeyFilePassphrase(String privateKeyFilePassphrase) {
        this.privateKeyPassphrase = privateKeyFilePassphrase;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public String getStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(String strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public void setServerAliveInterval(int serverAliveInterval) {
        this.serverAliveInterval = serverAliveInterval;
    }

    public int getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public void setServerAliveCountMax(int serverAliveCountMax) {
        this.serverAliveCountMax = serverAliveCountMax;
    }

    public int getServerAliveCountMax() {
        return this.serverAliveCountMax;
    }

    public void setChmod(String chmod) {
        this.chmod = chmod;
    }

    public String getChmod() {
        return this.chmod;
    }

    public void setChmodDirectory(String chmodDirectory) {
        this.chmodDirectory = chmodDirectory;
    }

    public String getChmodDirectory() {
        return this.chmodDirectory;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public void setPreferredAuthentications(String pAuthentications) {
        this.preferredAuthentications = pAuthentications;
    }

    public String getPreferredAuthentications() {
        return this.preferredAuthentications;
    }

    public LoggingLevel getJschLoggingLevel() {
        return this.jschLoggingLevel;
    }

    public void setJschLoggingLevel(LoggingLevel jschLoggingLevel) {
        this.jschLoggingLevel = jschLoggingLevel;
    }

    public void setBulkRequests(Integer bulkRequests) {
        this.bulkRequests = bulkRequests;
    }

    public Integer getBulkRequests() {
        return this.bulkRequests;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public boolean isExistDirCheckUsingLs() {
        return this.existDirCheckUsingLs;
    }

    public void setExistDirCheckUsingLs(boolean existDirCheckUsingLs) {
        this.existDirCheckUsingLs = existDirCheckUsingLs;
    }

    public String getKeyExchangeProtocols() {
        return this.keyExchangeProtocols;
    }

    public void setKeyExchangeProtocols(String keyExchangeProtocols) {
        this.keyExchangeProtocols = keyExchangeProtocols;
    }

    public String getServerHostKeys() {
        return this.serverHostKeys;
    }

    public void setServerHostKeys(String serverHostKeys) {
        this.serverHostKeys = serverHostKeys;
    }

    public String getPublicKeyAcceptedAlgorithms() {
        return this.publicKeyAcceptedAlgorithms;
    }

    public void setPublicKeyAcceptedAlgorithms(String publicKeyAcceptedAlgorithms) {
        this.publicKeyAcceptedAlgorithms = publicKeyAcceptedAlgorithms;
    }

    public String getFilenameEncoding() {
        return this.filenameEncoding;
    }

    public void setFilenameEncoding(String filenameEncoding) {
        this.filenameEncoding = filenameEncoding;
    }

    public LoggingLevel getServerMessageLoggingLevel() {
        return this.serverMessageLoggingLevel;
    }

    public void setServerMessageLoggingLevel(LoggingLevel serverMessageLoggingLevel) {
        this.serverMessageLoggingLevel = serverMessageLoggingLevel;
    }
}

