/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.MoveExistingFileStrategyUtils;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.FtpOperations;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpDefaultMoveExistingFileStrategy
implements FileMoveExistingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FtpDefaultMoveExistingFileStrategy.class);

    public boolean moveExistingFile(GenericFileEndpoint<?> endpoint, GenericFileOperations<?> operations, String fileName) throws GenericFileOperationFailedException {
        String to;
        block8: {
            Exchange dummy = endpoint.createExchange();
            String parent = FileUtil.stripLeadingSeparator((String)FileUtil.onlyPath((String)fileName));
            String onlyName = FileUtil.stripPath((String)fileName);
            dummy.getIn().setHeader("CamelFileName", (Object)fileName);
            dummy.getIn().setHeader("CamelFileNameOnly", (Object)onlyName);
            dummy.getIn().setHeader("CamelFileParent", (Object)parent);
            to = (String)endpoint.getMoveExisting().evaluate(dummy, String.class);
            to = FileUtil.stripLeadingSeparator((String)to);
            if (ObjectHelper.isEmpty((String)to)) {
                throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + fileName);
            }
            to = MoveExistingFileStrategyUtils.completePartialRelativePath((String)to, (String)onlyName, (String)parent);
            to = ((FtpEndpoint)endpoint).getConfiguration().normalizePath(to);
            String dir = FileUtil.onlyPath((String)to);
            if (dir != null) {
                operations.buildDirectory(dir, false);
            }
            if (operations.existsFile(to)) {
                if (endpoint.isEagerDeleteTargetFile()) {
                    LOG.trace("Deleting existing file: {}", (Object)to);
                    try {
                        boolean result = ((FtpOperations)operations).getClient().deleteFile(to);
                        if (!result) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + to);
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        throw new GenericFileOperationFailedException(((FtpOperations)operations).getClient().getReplyCode(), ((FtpOperations)operations).getClient().getReplyString(), "Cannot delete file: " + to, (Throwable)e);
                    }
                }
                throw new GenericFileOperationFailedException("Cannot move existing file from: " + fileName + " to: " + to + " as there already exists a file: " + to);
            }
        }
        LOG.trace("Moving existing file: {} to: {}", (Object)fileName, (Object)to);
        if (!operations.renameFile(fileName, to)) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + fileName + " to: " + to);
        }
        return true;
    }
}

