/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFileProducer<T>
extends GenericFileProducer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFileProducer.class);
    private boolean loggedIn;
    private transient String remoteFileProducerToString;

    protected RemoteFileProducer(RemoteFileEndpoint<T> endpoint, RemoteFileOperations<T> operations) {
        super(endpoint, operations);
    }

    public String getFileSeparator() {
        return "/";
    }

    public String normalizePath(String name) {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String existing = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        String target = this.createFileName(exchange);
        try {
            this.processExchange(exchange, target);
        }
        finally {
            exchange.getIn().removeHeader("CamelOverruleFileName");
            exchange.getIn().setHeader("CamelFileName", (Object)existing);
        }
    }

    protected RemoteFileOperations<T> getOperations() {
        return (RemoteFileOperations)this.operations;
    }

    public RemoteFileEndpoint<T> getEndpoint() {
        return (RemoteFileEndpoint)super.getEndpoint();
    }

    public void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        this.loggedIn = false;
        LOG.warn("Writing file failed with: {}", (Object)exception.getMessage());
        try {
            this.disconnect();
        }
        catch (Exception e) {
            LOG.debug("Ignored exception during disconnect: {}", (Object)e.getMessage());
        }
        throw exception;
    }

    public void disconnect() throws GenericFileOperationFailedException {
        this.loggedIn = false;
        if (this.getOperations().isConnected()) {
            LOG.debug("Disconnecting from: {}", this.getEndpoint());
            this.getOperations().disconnect();
        }
    }

    public void preWriteCheck(Exchange exchange) throws Exception {
        boolean noop = false;
        if (this.loggedIn) {
            if (this.getEndpoint().getConfiguration().isSendNoop()) {
                try {
                    noop = this.getOperations().sendNoop();
                }
                catch (Exception e) {
                    noop = false;
                    this.loggedIn = false;
                }
                LOG.trace("preWriteCheck send noop success: {}", (Object)noop);
            } else {
                noop = true;
                LOG.trace("preWriteCheck send noop disabled");
            }
        }
        if (!noop) {
            try {
                this.connectIfNecessary(exchange);
            }
            catch (Exception e) {
                this.loggedIn = false;
                throw e;
            }
        }
    }

    public void postWriteCheck(Exchange exchange) {
        try {
            boolean isLast = (Boolean)exchange.getProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)false, Boolean.class);
            if (isLast && this.getEndpoint().isDisconnectOnBatchComplete()) {
                LOG.trace("postWriteCheck disconnect on batch complete from: {}", this.getEndpoint());
                this.disconnect();
            }
            if (this.getEndpoint().isDisconnect()) {
                LOG.trace("postWriteCheck disconnect from: {}", this.getEndpoint());
                this.disconnect();
            }
        }
        catch (GenericFileOperationFailedException e) {
            LOG.warn("Exception occurred during disconnecting from: {} {}", this.getEndpoint(), (Object)e.getMessage());
        }
    }

    protected void doStart() throws Exception {
        LOG.debug("Starting");
        super.doStart();
    }

    protected void doStop() throws Exception {
        try {
            this.disconnect();
        }
        catch (Exception e) {
            LOG.debug("Exception occurred during disconnecting from: {} {}", this.getEndpoint(), (Object)e.getMessage());
        }
        super.doStop();
    }

    protected void connectIfNecessary(Exchange exchange) throws GenericFileOperationFailedException {
        if (!this.loggedIn || !this.getOperations().isConnected()) {
            LOG.debug("Not already connected/logged in. Connecting to: {}", this.getEndpoint());
            RemoteFileConfiguration config = this.getEndpoint().getConfiguration();
            this.loggedIn = this.getOperations().connect(config, exchange);
            if (!this.loggedIn) {
                return;
            }
            LOG.debug("Connected and logged in to: {}", this.getEndpoint());
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public String toString() {
        if (this.remoteFileProducerToString == null) {
            this.remoteFileProducerToString = "RemoteFileProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.remoteFileProducerToString;
    }
}

