/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFilePollingConsumerPollStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public abstract class RemoteFileConsumer<T>
extends GenericFileConsumer<T> {
    protected transient boolean loggedIn;
    protected transient boolean loggedInWarning;

    public RemoteFileConsumer(RemoteFileEndpoint<T> endpoint, Processor processor, RemoteFileOperations<T> operations, GenericFileProcessStrategy processStrategy) {
        super(endpoint, processor, operations, processStrategy);
        this.setPollStrategy((PollingConsumerPollStrategy)new RemoteFilePollingConsumerPollStrategy());
    }

    public RemoteFileEndpoint<T> getEndpoint() {
        return (RemoteFileEndpoint)super.getEndpoint();
    }

    protected RemoteFileOperations<T> getOperations() {
        return (RemoteFileOperations)this.operations;
    }

    protected boolean prePollCheck() throws Exception {
        block5: {
            if (this.log.isTraceEnabled()) {
                this.log.trace("prePollCheck on {}", (Object)this.getEndpoint().getConfiguration().remoteServerInformation());
            }
            try {
                this.connectIfNecessary();
            }
            catch (Exception e) {
                this.loggedIn = false;
                if (!this.getEndpoint().getConfiguration().isThrowExceptionOnConnectFailed()) break block5;
                throw e;
            }
        }
        if (!this.loggedIn) {
            String message = "Cannot connect/login to: " + this.remoteServer() + ". Will skip this poll.";
            if (!this.loggedInWarning) {
                this.log.warn(message);
                this.loggedInWarning = true;
            }
            return false;
        }
        this.loggedInWarning = false;
        return true;
    }

    protected void postPollCheck(int polledMessages) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("postPollCheck on {}", (Object)this.getEndpoint().getConfiguration().remoteServerInformation());
        }
        if (polledMessages == 0 && this.getEndpoint().isDisconnect()) {
            this.log.trace("postPollCheck disconnect from: {}", this.getEndpoint());
            this.disconnect();
        }
    }

    protected boolean processExchange(Exchange exchange) {
        exchange.setProperty("CamelUnitOfWorkProcessSync", (Object)Boolean.TRUE);
        boolean isLast = (Boolean)exchange.getProperty("CamelBatchComplete", (Object)true, Boolean.class);
        if (isLast && this.getEndpoint().isDisconnect()) {
            exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    RemoteFileConsumer.this.log.trace("processExchange disconnect from: {}", RemoteFileConsumer.this.getEndpoint());
                    RemoteFileConsumer.this.disconnect();
                }

                public boolean allowHandover() {
                    return false;
                }

                public int getOrder() {
                    return Integer.MAX_VALUE;
                }

                public String toString() {
                    return "Disconnect";
                }
            });
        }
        return super.processExchange(exchange);
    }

    protected boolean isRetrieveFile() {
        return this.getEndpoint().isDownload();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.disconnect();
    }

    protected void disconnect() {
        this.loggedIn = false;
        try {
            if (this.getOperations().isConnected()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disconnecting from: {}", (Object)this.remoteServer());
                }
                this.getOperations().disconnect();
            }
        }
        catch (GenericFileOperationFailedException e) {
            this.log.warn("Error occurred while disconnecting from " + this.remoteServer() + " due: " + e.getMessage() + ". This exception will be ignored.");
        }
    }

    protected void forceDisconnect() {
        this.loggedIn = false;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Force disconnecting from: {}", (Object)this.remoteServer());
            }
            this.getOperations().forceDisconnect();
        }
        catch (GenericFileOperationFailedException e) {
            this.log.warn("Error occurred while disconnecting from " + this.remoteServer() + " due: " + e.getMessage() + ". This exception will be ignored.");
        }
    }

    protected void connectIfNecessary() throws IOException {
        boolean isConnected;
        block5: {
            isConnected = false;
            try {
                isConnected = this.getOperations().sendNoop();
            }
            catch (Exception ex) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug("Exception checking connection status: {}", (Object)ex.getMessage());
            }
        }
        if (!this.loggedIn || !isConnected) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Not connected/logged in, connecting to: {}", (Object)this.remoteServer());
            }
            this.loggedIn = this.getOperations().connect((RemoteFileConfiguration)this.endpoint.getConfiguration());
            if (this.loggedIn) {
                this.log.debug("Connected and logged in to: {}", (Object)this.remoteServer());
            }
        }
    }

    protected String remoteServer() {
        return ((RemoteFileEndpoint)this.endpoint).remoteServerInformation();
    }

    protected boolean doSafePollSubDirectory(String absolutePath, String dirName, List<GenericFile<T>> fileList, int depth) {
        try {
            this.log.trace("Polling sub directory: {} from: {}", (Object)absolutePath, (Object)this.endpoint);
            return this.doPollDirectory(absolutePath, dirName, fileList, depth);
        }
        catch (Exception e) {
            this.log.debug("Caught exception {}", (Object)e.getMessage());
            if (this.ignoreCannotRetrieveFile(absolutePath, null, e)) {
                this.log.trace("Ignoring file error {} for {}", (Object)e.getMessage(), (Object)absolutePath);
                return true;
            }
            this.log.trace("Not ignoring file error {} for {}", (Object)e.getMessage(), (Object)absolutePath);
            if (e instanceof GenericFileOperationFailedException) {
                throw (GenericFileOperationFailedException)((Object)e);
            }
            throw new GenericFileOperationFailedException("Cannot poll sub-directory: " + absolutePath + " from: " + this.endpoint, (Throwable)e);
        }
    }

    protected abstract boolean doPollDirectory(String var1, String var2, List<GenericFile<T>> var3, int var4);
}

