/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flowable;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.flowable.CamelOperationsOutboundEventChannelAdapter;
import org.apache.camel.component.flowable.FlowableEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.OutboundEventChannelAdapter;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.model.CamelInboundChannelModel;
import org.flowable.eventregistry.model.CamelOutboundChannelModel;
import org.flowable.eventregistry.model.ChannelModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelChannelModelProcessor
implements ChannelModelProcessor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected CamelContext camelContext;

    public CamelChannelModelProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean canProcess(ChannelModel channelModel) {
        return channelModel instanceof CamelInboundChannelModel || channelModel instanceof CamelOutboundChannelModel;
    }

    public boolean canProcessIfChannelModelAlreadyRegistered(ChannelModel channelModel) {
        return channelModel instanceof CamelOutboundChannelModel;
    }

    public void registerChannelModel(ChannelModel channelModel, String tenantId, EventRegistry eventRegistry, EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        if (channelModel instanceof CamelInboundChannelModel) {
            CamelInboundChannelModel camelInboundChannelModel = (CamelInboundChannelModel)channelModel;
            this.logger.debug("Starting to register inbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
            this.processInboundDefinition(camelInboundChannelModel, tenantId);
            this.logger.debug("Finished registering inbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
        } else if (channelModel instanceof CamelOutboundChannelModel) {
            CamelOutboundChannelModel camelOutboundChannelModel = (CamelOutboundChannelModel)channelModel;
            this.logger.debug("Starting to register outbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
            this.processOutboundDefinition(camelOutboundChannelModel, tenantId);
            this.logger.debug("Finished registering outbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
        }
    }

    protected void processInboundDefinition(final CamelInboundChannelModel channelModel, String tenantId) {
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration();
        try (final FlowableEndpoint endpoint = new FlowableEndpoint(channelModel, eventRegistryEngineConfiguration);){
            this.camelContext.addEndpoint(endpoint.getEndpointUri(), (Endpoint)endpoint);
            if (StringUtils.isNotEmpty((CharSequence)channelModel.getSourceUri())) {
                this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

                    public void configure() throws Exception {
                        this.from(channelModel.getSourceUri()).routeId(channelModel.getKey()).to(endpoint.getEndpointUri());
                    }
                });
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error creating producer for inbound channel " + channelModel.getKey() + " in tenant " + tenantId);
        }
    }

    protected void processOutboundDefinition(CamelOutboundChannelModel channelModel, String tenantId) {
        String destination = channelModel.getDestination();
        if (channelModel.getOutboundEventChannelAdapter() == null && StringUtils.isNotEmpty((CharSequence)destination)) {
            channelModel.setOutboundEventChannelAdapter(this.createOutboundEventChannelAdapter(channelModel, tenantId));
        }
    }

    protected OutboundEventChannelAdapter<String> createOutboundEventChannelAdapter(final CamelOutboundChannelModel channelModel, String tenantId) {
        CamelOperationsOutboundEventChannelAdapter camelOperationsOutboundEventChannelAdapter;
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration();
        final String destination = this.resolve(channelModel.getDestination());
        final FlowableEndpoint endpoint = new FlowableEndpoint(channelModel, eventRegistryEngineConfiguration);
        try {
            this.camelContext.addEndpoint(endpoint.getEndpointUri(), (Endpoint)endpoint);
            this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from((Endpoint)endpoint).routeId(channelModel.getKey()).to(destination);
                }
            });
            camelOperationsOutboundEventChannelAdapter = new CamelOperationsOutboundEventChannelAdapter(endpoint);
        }
        catch (Throwable throwable) {
            try {
                try {
                    endpoint.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FlowableException("Error creating route for outbound channel " + channelModel.getKey() + " in tenant " + tenantId);
            }
        }
        endpoint.close();
        return camelOperationsOutboundEventChannelAdapter;
    }

    public void unregisterChannelModel(ChannelModel channelModel, String tenantId, EventRepositoryService eventRepositoryService) {
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected String resolve(String value) {
        return value;
    }
}

