/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.spi.Metadata;

public final class FileConstants {
    @Metadata(label="consumer", description="A `long` value containing the file size.", javaType="long")
    public static final String FILE_LENGTH = "CamelFileLength";
    @Metadata(label="consumer", description="A `Long` value containing the last modified timestamp of the file.", javaType="long")
    public static final String FILE_LAST_MODIFIED = "CamelFileLastModified";
    @Metadata(label="producer", description="The local work path", javaType="File")
    public static final String FILE_LOCAL_WORK_PATH = "CamelFileLocalWorkPath";
    @Metadata(description="Only the file name (the name with no leading paths).", javaType="String")
    public static final String FILE_NAME_ONLY = "CamelFileNameOnly";
    @Metadata(description="(producer) Specifies the name of the file to write (relative to the endpoint\ndirectory). This name can be a `String`; a `String` with a\nxref:languages:file-language.adoc[File Language] or xref:languages:simple-language.adoc[Simple]\nexpression; or an Expression object. If it's\n`null` then Camel will auto-generate a filename based on the message\nunique ID. (consumer) Name of the consumed file as a relative file path with offset from the\nstarting directory configured on the endpoint.", javaType="String")
    public static final String FILE_NAME = "CamelFileName";
    @Metadata(label="consumer", description="The name of the file that has been consumed", javaType="String")
    public static final String FILE_NAME_CONSUMED = "CamelFileNameConsumed";
    @Metadata(label="consumer", description="A `boolean` option specifying whether the consumed file denotes an\nabsolute path or not. Should normally be `false` for relative paths.\nAbsolute paths should normally not be used but we added to the move\noption to allow moving files to absolute paths. But can be used\nelsewhere as well.", javaType="Boolean")
    public static final String FILE_ABSOLUTE = "CamelFileAbsolute";
    @Metadata(label="consumer", description="The absolute path to the file. For relative files this path holds the\nrelative path instead.", javaType="String")
    public static final String FILE_ABSOLUTE_PATH = "CamelFileAbsolutePath";
    @Metadata(label="consumer", description="The extended attributes of the file", javaType="Map<String, Object>")
    public static final String FILE_EXTENDED_ATTRIBUTES = "CamelFileExtendedAttributes";
    @Metadata(label="consumer", description="The content type of the file", javaType="String")
    public static final String FILE_CONTENT_TYPE = "CamelFileContentType";
    @Metadata(label="consumer", description="The file path. For relative files this is the starting directory + the\nrelative filename. For absolute files this is the absolute path.", javaType="String")
    public static final String FILE_PATH = "CamelFilePath";
    @Metadata(label="consumer", description="The relative path.", javaType="String")
    public static final String FILE_RELATIVE_PATH = "CamelFileRelativePath";
    @Metadata(description="The parent path.", javaType="String")
    public static final String FILE_PARENT = "CamelFileParent";
    @Metadata(label="producer", description="The actual absolute filepath (path + name) for the output file that was\nwritten. This header is set by Camel and its purpose is providing\nend-users with the name of the file that was written.", javaType="String")
    public static final String FILE_NAME_PRODUCED = "CamelFileNameProduced";
    @Metadata(label="producer", description="Is used for overruling `CamelFileName` header and use the\nvalue instead (but only once, as the producer will remove this header\nafter writing the file). The value can be only be a String. Notice that\nif the option `fileName` has been configured, then this is still being\nevaluated.", javaType="Object")
    public static final String OVERRULE_FILE_NAME = "CamelOverruleFileName";
    @Metadata(label="consumer", description="A `long` value containing the initial offset.", javaType="long")
    public static final String INITIAL_OFFSET = "CamelFileInitialOffset";
    public static final String DEFAULT_SUB_FOLDER = ".camel";

    private FileConstants() {
    }
}

