/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.support.MessageHelper;

public final class GenericFileHelper {
    private GenericFileHelper() {
    }

    public static String asExclusiveReadLockKey(GenericFile file, String key) {
        String path = file.getCopyFromAbsoluteFilePath() != null ? file.getCopyFromAbsoluteFilePath() : file.getAbsoluteFilePath();
        return GenericFileHelper.asExclusiveReadLockKey(path, key);
    }

    public static String asExclusiveReadLockKey(String path, String key) {
        return path + "-" + key;
    }

    public static <T> Exchange createDummy(GenericFileEndpoint<T> endpoint, Exchange dynamic, Supplier<GenericFile<T>> file) {
        Exchange dummy = endpoint.createExchange(file.get());
        if (dynamic != null && dynamic.getMessage().hasHeaders()) {
            MessageHelper.copyHeaders((Message)dynamic.getMessage(), (Message)dummy.getMessage(), (boolean)true);
            if (dynamic.hasVariables()) {
                dummy.getVariables().putAll(dynamic.getVariables());
            }
        }
        return dummy;
    }
}

