/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.cluster;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.file.cluster.FileLockClusterService;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockClusterView
extends AbstractCamelClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockClusterView.class);
    private final ClusterMember localMember = new ClusterMember();
    private final Path path;
    private RandomAccessFile lockFile;
    private FileLock lock;
    private ScheduledFuture<?> task;

    FileLockClusterView(FileLockClusterService cluster, String namespace) {
        super((CamelClusterService)cluster, namespace);
        this.path = Paths.get(cluster.getRoot(), namespace);
    }

    public Optional<CamelClusterMember> getLeader() {
        return this.localMember.isLeader() ? Optional.of(this.localMember) : Optional.empty();
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public List<CamelClusterMember> getMembers() {
        return Collections.emptyList();
    }

    protected void doStart() throws Exception {
        if (this.lockFile != null) {
            this.closeInternal();
            this.fireLeadershipChangedEvent(Optional.empty());
        }
        if (!Files.exists(this.path.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        }
        FileLockClusterService service = (FileLockClusterService)this.getClusterService().unwrap(FileLockClusterService.class);
        ScheduledExecutorService executor = service.getExecutor();
        this.task = executor.scheduleAtFixedRate(this::tryLock, TimeUnit.MILLISECONDS.convert(service.getAcquireLockDelay(), service.getAcquireLockDelayUnit()), TimeUnit.MILLISECONDS.convert(service.getAcquireLockInterval(), service.getAcquireLockIntervalUnit()), TimeUnit.MILLISECONDS);
    }

    protected void doStop() throws Exception {
        this.closeInternal();
    }

    private void closeInternal() throws Exception {
        if (this.task != null) {
            this.task.cancel(true);
        }
        if (this.lock != null) {
            this.lock.release();
        }
        this.closeLockFile();
    }

    private void closeLockFile() {
        if (this.lockFile != null) {
            try {
                this.lockFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.lockFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLock() {
        if (this.isStarting() || this.isStarted()) {
            Exception reason = null;
            try {
                if (this.localMember.isLeader()) {
                    LOGGER.trace("Holding the lock on file {} (lock={})", (Object)this.path, (Object)this.lock);
                    return;
                }
                FileLockClusterView fileLockClusterView = this;
                synchronized (fileLockClusterView) {
                    if (this.lock != null) {
                        LOGGER.info("Lock on file {} lost (lock={})", (Object)this.path, (Object)this.lock);
                        this.fireLeadershipChangedEvent(Optional.empty());
                    }
                    LOGGER.debug("Try to acquire a lock on {}", (Object)this.path);
                    this.lockFile = new RandomAccessFile(this.path.toFile(), "rw");
                    this.lock = null;
                    this.lock = this.lockFile.getChannel().tryLock(0L, Math.max(1L, this.lockFile.getChannel().size()), false);
                    if (this.lock != null) {
                        LOGGER.info("Lock on file {} acquired (lock={})", (Object)this.path, (Object)this.lock);
                        this.fireLeadershipChangedEvent(Optional.of(this.localMember));
                    } else {
                        LOGGER.debug("Lock on file {} not acquired ", (Object)this.path);
                    }
                }
            }
            catch (OverlappingFileLockException e) {
                reason = new IOException(e);
            }
            catch (Exception e) {
                reason = e;
            }
            if (this.lock == null) {
                LOGGER.debug("Lock on file {} not acquired ", (Object)this.path, (Object)reason);
                this.closeLockFile();
            }
        }
    }

    private final class ClusterMember
    implements CamelClusterMember {
        private ClusterMember() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLeader() {
            FileLockClusterView fileLockClusterView = FileLockClusterView.this;
            synchronized (fileLockClusterView) {
                return FileLockClusterView.this.lock != null && FileLockClusterView.this.lock.isValid();
            }
        }

        public boolean isLocal() {
            return true;
        }

        public String getId() {
            return FileLockClusterView.this.getClusterService().getId();
        }
    }
}

