/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public final class FileResumeSet {
    private final File[] inputFiles;
    private File[] outputFiles;

    public FileResumeSet(File[] inputFiles) {
        Objects.requireNonNull(inputFiles, "A list of input files must be provided for the resume info");
        this.inputFiles = inputFiles;
    }

    public void resumeEach(Predicate<File> resumableCheck) {
        this.outputFiles = null;
        File[] tmp = Arrays.copyOf(this.inputFiles, this.inputFiles.length);
        int count = 0;
        for (File file : this.inputFiles) {
            if (!resumableCheck.test(file)) continue;
            tmp[count] = file;
            ++count;
        }
        this.outputFiles = Arrays.copyOf(tmp, count);
    }

    public File[] resumedFiles() {
        return this.outputFiles;
    }

    public boolean hasResumables() {
        return this.outputFiles != null && this.outputFiles.length > 0;
    }
}

