/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileHelper;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperations
implements GenericFileOperations<File> {
    private static final Logger LOG = LoggerFactory.getLogger(FileOperations.class);
    private FileEndpoint endpoint;

    public FileOperations() {
    }

    public FileOperations(FileEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public GenericFile<File> newGenericFile() {
        return new GenericFile<File>();
    }

    @Override
    public void setEndpoint(GenericFileEndpoint<File> endpoint) {
        this.endpoint = (FileEndpoint)endpoint;
    }

    @Override
    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        File file = new File(name);
        return FileUtil.deleteFile((File)file);
    }

    @Override
    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        boolean renamed = false;
        File file = new File(from);
        File target = new File(to);
        try {
            renamed = this.endpoint.isRenameUsingCopy() ? FileUtil.renameFileUsingCopy((File)file, (File)target) : FileUtil.renameFile((File)file, (File)target, (boolean)this.endpoint.isCopyAndDeleteOnRenameFail());
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Error renaming file from " + from + " to " + to, e);
        }
        return renamed;
    }

    @Override
    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        File file = new File(name);
        return file.exists();
    }

    protected boolean buildDirectory(File dir, Set<PosixFilePermission> permissions, boolean absolute) {
        if (dir.exists()) {
            return true;
        }
        if (permissions == null || permissions.isEmpty()) {
            return dir.mkdirs();
        }
        try {
            String[] parts = dir.getPath().split("\\" + File.separatorChar);
            File base = absolute ? new File("") : new File(".");
            for (String part : parts) {
                File subDir = new File(base, part);
                if (!subDir.exists()) {
                    if (subDir.mkdir()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Setting chmod: {} on directory: {}", (Object)PosixFilePermissions.toString(permissions), (Object)subDir);
                        }
                        Files.setPosixFilePermissions(subDir.toPath(), permissions);
                    } else {
                        return false;
                    }
                }
                base = new File(base, subDir.getName());
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Error setting chmod on directory: " + dir, e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        String afterRoot;
        boolean isPath;
        ObjectHelper.notNull((Object)((Object)this.endpoint), (String)"endpoint");
        if (this.endpoint.isAutoCreate() && !this.endpoint.getFile().exists()) {
            LOG.trace("Building starting directory: {}", (Object)this.endpoint.getFile());
            this.buildDirectory(this.endpoint.getFile(), this.endpoint.getDirectoryPermissions(), absolute);
        }
        if (ObjectHelper.isEmpty((Object)directory)) {
            return true;
        }
        File endpointPath = this.endpoint.getFile();
        File target = new File(directory);
        boolean bl = isPath = directory.contains("/") || directory.contains("\\");
        File path = absolute ? target : (endpointPath.equals(target) ? endpointPath : (isPath ? (ObjectHelper.isNotEmpty((Object)(afterRoot = StringHelper.after((String)directory, (String)(endpointPath.getPath() + File.separator)))) ? new File(this.endpoint.getFile(), afterRoot) : new File(directory)) : new File(this.endpoint.getFile(), directory)));
        FileOperations fileOperations = this;
        synchronized (fileOperations) {
            if (path.isDirectory() && path.exists()) {
                return true;
            }
            LOG.trace("Building directory: {}", (Object)path);
            return this.buildDirectory(path, this.endpoint.getDirectoryPermissions(), absolute);
        }
    }

    public File[] listFiles() throws GenericFileOperationFailedException {
        return null;
    }

    public File[] listFiles(String path) throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
    }

    @Override
    public void changeToParentDirectory() throws GenericFileOperationFailedException {
    }

    @Override
    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public boolean retrieveFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        return true;
    }

    @Override
    public void releaseRetrievedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
    }

    @Override
    public boolean storeFile(String fileName, Exchange exchange, long size) throws GenericFileOperationFailedException {
        ObjectHelper.notNull((Object)((Object)this.endpoint), (String)"endpoint");
        File file = new File(fileName);
        if (file.exists()) {
            if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                LOG.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)file);
                return true;
            }
            if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + file + ". Cannot write new file.");
            }
            if (this.endpoint.getFileExist() == GenericFileExist.Move) {
                this.endpoint.getMoveExistingFileStrategy().moveExistingFile(this.endpoint, this, fileName);
            }
        }
        if (exchange.getIn().getBody() == null) {
            if (this.endpoint.isAllowNullBody()) {
                LOG.trace("Writing empty file.");
                try {
                    this.writeFileEmptyBody(file);
                    return true;
                }
                catch (IOException e) {
                    throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
                }
            }
            throw new GenericFileOperationFailedException("Cannot write null body to file: " + file);
        }
        try {
            Set<PosixFilePermission> permissions;
            Closeable in;
            String charset = this.endpoint.getCharset();
            File source = null;
            boolean fileBased = false;
            if (charset == null && this.endpoint.getFileExist() != GenericFileExist.Append) {
                Object maybeFile;
                WrappedFile wrapped;
                Object body = exchange.getIn().getBody();
                if (body instanceof WrappedFile && !((body = (wrapped = (WrappedFile)body).getFile()) instanceof File) && (maybeFile = wrapped.getBody()) instanceof File) {
                    body = maybeFile;
                }
                if (body instanceof File) {
                    source = (File)body;
                    fileBased = true;
                }
            }
            if (fileBased) {
                File local = (File)exchange.getIn().getHeader("CamelFileLocalWorkPath", File.class);
                if (local != null && local.exists()) {
                    boolean renamed = this.writeFileByLocalWorkPath(local, file);
                    if (renamed) {
                        Set<PosixFilePermission> permissions2;
                        this.keepLastModified(exchange, file);
                        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getChmod()) && !(permissions2 = this.endpoint.getPermissions()).isEmpty()) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Setting chmod: {} on file: {}", (Object)PosixFilePermissions.toString(permissions2), (Object)file);
                            }
                            Files.setPosixFilePermissions(file.toPath(), permissions2);
                        }
                        exchange.getIn().setHeader("CamelFileLocalWorkPath", null);
                        return true;
                    }
                } else if (source != null && source.exists()) {
                    Set<PosixFilePermission> permissions3;
                    this.writeFileByFile(source, file, exchange);
                    this.keepLastModified(exchange, file);
                    if (ObjectHelper.isNotEmpty((Object)this.endpoint.getChmod()) && !(permissions3 = this.endpoint.getPermissions()).isEmpty()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Setting chmod: {} on file: {}", (Object)PosixFilePermissions.toString(permissions3), (Object)file);
                        }
                        Files.setPosixFilePermissions(file.toPath(), permissions3);
                    }
                    return true;
                }
            }
            if (charset != null) {
                in = (Reader)exchange.getContext().getTypeConverter().tryConvertTo(Reader.class, exchange, exchange.getIn().getBody());
                if (in == null) {
                    InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                    in = new InputStreamReader(is);
                }
                in = IOHelper.buffered((Reader)in);
                this.writeFileByReaderWithCharset((Reader)in, file, charset);
            } else {
                in = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                this.writeFileByStream((InputStream)in, file);
            }
            this.keepLastModified(exchange, file);
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getChmod()) && !(permissions = this.endpoint.getPermissions()).isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Setting chmod: {} on file: {}", (Object)PosixFilePermissions.toString(permissions), (Object)file);
                }
                Files.setPosixFilePermissions(file.toPath(), permissions);
            }
            return true;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
        }
        catch (InvalidPayloadException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
        }
    }

    private void keepLastModified(Exchange exchange, File file) {
        Date date;
        Long last;
        if (this.endpoint.isKeepLastModified() && (last = (date = (Date)exchange.getIn().getHeader("CamelFileLastModified", Date.class)) != null ? Long.valueOf(date.getTime()) : (Long)exchange.getIn().getHeader("CamelFileLastModified", Long.class)) != null) {
            boolean result = file.setLastModified(last);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Keeping last modified timestamp: {} on file: {} with result: {}", new Object[]{last, file, result});
            }
        }
    }

    private boolean writeFileByLocalWorkPath(File source, File file) throws IOException {
        LOG.trace("writeFileByFile using local work file being renamed from: {} to: {}", (Object)source, (Object)file);
        return FileUtil.renameFile((File)source, (File)file, (boolean)this.endpoint.isCopyAndDeleteOnRenameFail());
    }

    private void writeFileByFile(File source, File target, Exchange exchange) throws IOException {
        String path = source.getAbsolutePath();
        FileChannel channel = (FileChannel)exchange.getProperty(GenericFileHelper.asExclusiveReadLockKey(path, "CamelFileLockChannelFile"), FileChannel.class);
        if (channel != null) {
            try (FileChannel out = new FileOutputStream(target).getChannel();){
                LOG.trace("writeFileByFile using FileChannel: {} -> {}", (Object)source, (Object)target);
                channel.transferTo(0L, channel.size(), out);
            }
        } else {
            LOG.trace("writeFileByFile using Files.copy: {} -> {}", (Object)source, (Object)target);
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByStream(InputStream in, File target) throws IOException {
        try (SeekableByteChannel out = this.prepareOutputFileChannel(target);){
            boolean append;
            int bytesRead;
            LOG.debug("Using InputStream to write file: {}", (Object)target);
            int size = this.endpoint.getBufferSize();
            byte[] buffer = new byte[size];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            while ((bytesRead = in.read(buffer)) != -1) {
                ByteBuffer buf;
                if (bytesRead < size) {
                    buf = byteBuffer;
                    ((Buffer)buf).limit(bytesRead);
                }
                out.write(byteBuffer);
                buf = byteBuffer;
                ((Buffer)buf).clear();
            }
            boolean bl = append = this.endpoint.getFileExist() == GenericFileExist.Append;
            if (append && this.endpoint.getAppendChars() != null) {
                byteBuffer = ByteBuffer.wrap(this.endpoint.getAppendChars().getBytes());
                out.write(byteBuffer);
                ByteBuffer buf = byteBuffer;
                ((Buffer)buf).clear();
            }
        }
        finally {
            IOHelper.close((Closeable)in, (String)target.getName(), (Logger)LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByReaderWithCharset(Reader in, File target, String charset) throws IOException {
        boolean append = this.endpoint.getFileExist() == GenericFileExist.Append;
        try (BufferedWriter out = Files.newBufferedWriter(target.toPath(), Charset.forName(charset), StandardOpenOption.WRITE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            LOG.debug("Using Reader to write file: {} with charset: {}", (Object)target, (Object)charset);
            int size = this.endpoint.getBufferSize();
            IOHelper.copy((Reader)in, (Writer)out, (int)size);
            if (append && this.endpoint.getAppendChars() != null) {
                out.write(this.endpoint.getAppendChars());
            }
        }
        finally {
            IOHelper.close((Closeable)in, (String)target.getName(), (Logger)LOG);
        }
    }

    private void writeFileEmptyBody(File target) throws IOException {
        if (!target.exists()) {
            LOG.debug("Creating new empty file: {}", (Object)target);
            FileUtil.createNewFile((File)target);
        } else if (this.endpoint.getFileExist() == GenericFileExist.Override) {
            LOG.debug("Truncating existing file: {}", (Object)target);
            SeekableByteChannel out = Files.newByteChannel(target.toPath(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            Throwable throwable = null;
            if (out != null) {
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    private SeekableByteChannel prepareOutputFileChannel(File target) throws IOException {
        if (this.endpoint.getFileExist() == GenericFileExist.Append) {
            SeekableByteChannel out = Files.newByteChannel(target.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            return out.position(out.size());
        }
        return Files.newByteChannel(target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }
}

