/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.watch.constants;

import io.methvin.watcher.DirectoryChangeEvent;
import java.nio.file.Path;
import org.apache.camel.component.file.watch.constants.FileEventEnum;

public class FileEvent {
    private FileEventEnum eventType;
    private Path eventPath;
    private long eventDate = System.currentTimeMillis();

    private FileEvent() {
    }

    public FileEvent(FileEventEnum eventType, Path eventPath) {
        this();
        this.eventType = eventType;
        this.eventPath = eventPath;
    }

    public FileEvent(DirectoryChangeEvent event) {
        this();
        this.eventType = FileEventEnum.valueOf(event.eventType());
        this.eventPath = event.path();
    }

    public FileEventEnum getEventType() {
        return this.eventType;
    }

    public Path getEventPath() {
        return this.eventPath;
    }

    public long getEventDate() {
        return this.eventDate;
    }
}

