/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.api.FhirOperation;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public enum FhirOperationApiMethod implements ApiMethod
{
    ON_INSTANCE(IBaseResource.class, "onInstance", ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"name", String.class), ApiMethodArg.arg((String)"parameters", IBaseParameters.class), ApiMethodArg.arg((String)"outputParameterType", Class.class), ApiMethodArg.arg((String)"useHttpGet", Boolean.TYPE), ApiMethodArg.arg((String)"returnType", Class.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    ON_INSTANCE_VERSION(IBaseResource.class, "onInstanceVersion", ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"name", String.class), ApiMethodArg.arg((String)"parameters", IBaseParameters.class), ApiMethodArg.arg((String)"outputParameterType", Class.class), ApiMethodArg.arg((String)"useHttpGet", Boolean.TYPE), ApiMethodArg.arg((String)"returnType", Class.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    ON_SERVER(IBaseResource.class, "onServer", ApiMethodArg.arg((String)"name", String.class), ApiMethodArg.arg((String)"parameters", IBaseParameters.class), ApiMethodArg.arg((String)"outputParameterType", Class.class), ApiMethodArg.arg((String)"useHttpGet", Boolean.TYPE), ApiMethodArg.arg((String)"returnType", Class.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    ON_TYPE(IBaseResource.class, "onType", ApiMethodArg.arg((String)"resourceType", Class.class), ApiMethodArg.arg((String)"name", String.class), ApiMethodArg.arg((String)"parameters", IBaseParameters.class), ApiMethodArg.arg((String)"outputParameterType", Class.class), ApiMethodArg.arg((String)"useHttpGet", Boolean.TYPE), ApiMethodArg.arg((String)"returnType", Class.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    PROCESS_MESSAGE(IBaseBundle.class, "processMessage", ApiMethodArg.arg((String)"respondToUri", String.class), ApiMethodArg.arg((String)"msgBundle", IBaseBundle.class), ApiMethodArg.arg((String)"asynchronous", Boolean.TYPE), ApiMethodArg.arg((String)"responseClass", Class.class), ApiMethodArg.arg((String)"extraParameters", Map.class));

    private final ApiMethod apiMethod;

    private FhirOperationApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(FhirOperation.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

