/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IDeleteTyped;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class FhirDelete {
    private final IGenericClient client;

    public FhirDelete(IGenericClient client) {
        this.client = client;
    }

    public MethodOutcome resource(IBaseResource resource, Map<ExtraParameters, Object> extraParameters) {
        IDeleteTyped deleteTyped = this.client.delete().resource(resource);
        ExtraParameters.process(extraParameters, deleteTyped);
        return (MethodOutcome)deleteTyped.execute();
    }

    public MethodOutcome resourceById(IIdType id, Map<ExtraParameters, Object> extraParameters) {
        IDeleteTyped deleteTyped = this.client.delete().resourceById(id);
        ExtraParameters.process(extraParameters, deleteTyped);
        return (MethodOutcome)deleteTyped.execute();
    }

    public MethodOutcome resourceById(String type, String stringId, Map<ExtraParameters, Object> extraParameters) {
        IDeleteTyped deleteTyped = this.client.delete().resourceById(type, stringId);
        ExtraParameters.process(extraParameters, deleteTyped);
        return (MethodOutcome)deleteTyped.execute();
    }

    public MethodOutcome resourceConditionalByUrl(String url, Map<ExtraParameters, Object> extraParameters) {
        IDeleteTyped deleteTyped = this.client.delete().resourceConditionalByUrl(url);
        ExtraParameters.process(extraParameters, deleteTyped);
        return (MethodOutcome)deleteTyped.execute();
    }
}

