/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.exec.ExecBinding;
import org.apache.camel.component.exec.ExecCommand;
import org.apache.camel.component.exec.ExecEndpoint;
import org.apache.camel.component.exec.ExecResult;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecProducer
extends DefaultProducer {
    private final Logger log;
    private final ExecEndpoint endpoint;

    public ExecProducer(ExecEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.log = LoggerFactory.getLogger(ExecProducer.class);
    }

    public void process(Exchange exchange) throws Exception {
        ExecCommand execCommand = this.getBinding().readInput(exchange, this.endpoint);
        if (this.log.isInfoEnabled()) {
            this.log.info("Executing " + execCommand);
        }
        ExecResult result = this.endpoint.getCommandExecutor().execute(execCommand);
        ObjectHelper.notNull((Object)result, (String)"The command executor must return a not-null result");
        if (this.log.isInfoEnabled()) {
            this.log.info("The command " + execCommand + " had exit value " + result.getExitValue());
        } else if (this.log.isErrorEnabled() && result.getExitValue() != 0) {
            this.log.error("The command " + execCommand + " returned exit value " + result.getExitValue());
        }
        this.getBinding().writeOutput(exchange, result);
    }

    private ExecBinding getBinding() {
        return this.endpoint.getBinding();
    }
}

