/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd3.processor.aggregate;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Txn;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Etcd3AggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository,
OptimisticLockingAggregationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(Etcd3AggregationRepository.class);
    private static final String COMPLETED_SUFFIX = "-completed";
    private boolean optimistic;
    private boolean useRecovery = true;
    private String endpoint;
    private Client client;
    private boolean shutdownClient;
    private KV kvClient;
    private String prefixName;
    private String persistencePrefixName;
    private String deadLetterChannel;
    private long recoveryInterval = 5000L;
    private int maximumRedeliveries = 3;
    private boolean allowSerializedHeaders;

    public Etcd3AggregationRepository() {
    }

    public Etcd3AggregationRepository(String prefixName, String endpoint) {
        this.prefixName = prefixName;
        this.persistencePrefixName = String.format("%s%s", prefixName, COMPLETED_SUFFIX);
        this.optimistic = false;
        this.endpoint = endpoint;
    }

    public Etcd3AggregationRepository(String prefixName, String persistencePrefixName, String endpoint) {
        this.prefixName = prefixName;
        this.persistencePrefixName = persistencePrefixName;
        this.optimistic = false;
        this.endpoint = endpoint;
    }

    public Etcd3AggregationRepository(String prefixName, String endpoint, boolean optimistic) {
        this(prefixName, endpoint);
        this.optimistic = optimistic;
    }

    public Etcd3AggregationRepository(String repositoryName, String persistentRepositoryName, String endpoint, boolean optimistic) {
        this(repositoryName, persistentRepositoryName, endpoint);
        this.optimistic = optimistic;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Exchange add(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) throws OptimisticLockingAggregationRepository.OptimisticLockingException {
        block7: {
            if (!this.optimistic) {
                throw new UnsupportedOperationException();
            }
            LOG.trace("Adding an Exchange with ID {} for key {} in an optimistic manner.", (Object)newExchange.getExchangeId(), (Object)key);
            try {
                if (oldExchange == null) {
                    DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)newExchange, (boolean)true, (boolean)this.allowSerializedHeaders);
                    CompletableFuture completableGetResponse = this.kvClient.get(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()));
                    GetResponse getResponse = (GetResponse)completableGetResponse.get();
                    List keyValues = getResponse.getKvs();
                    if (keyValues.isEmpty()) {
                        CompletableFuture completablePutResponse = this.kvClient.put(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()), this.convertToEtcd3Format(holder));
                        completablePutResponse.get();
                        break block7;
                    } else {
                        DefaultExchangeHolder misbehaviorHolder = (DefaultExchangeHolder)this.convertFromEtcd3Format(((KeyValue)keyValues.get(0)).getValue());
                        Exchange misbehaviorEx = this.unmarshallExchange(camelContext, misbehaviorHolder);
                        LOG.warn("Optimistic locking failed for exchange with key {}: kvClient.get returned Exchange with ID {}, while it's expected no exchanges to be returned", (Object)key, (Object)(misbehaviorEx != null ? misbehaviorEx.getExchangeId() : "<null>"));
                        throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
                    }
                }
                DefaultExchangeHolder newHolder = DefaultExchangeHolder.marshal((Exchange)newExchange, (boolean)true, (boolean)this.allowSerializedHeaders);
                CompletableFuture completableDeleteResponse = this.kvClient.delete(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()));
                DeleteResponse deleteResponse = (DeleteResponse)completableDeleteResponse.get();
                if (deleteResponse.getDeleted() == 0L) {
                    LOG.warn("Optimistic locking failed for exchange with key {}: kvClient.get returned no Exchanges, while it's expected to replace one", (Object)key);
                    throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
                }
                CompletableFuture completablePutResponse = this.kvClient.put(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()), this.convertToEtcd3Format(newHolder));
                completablePutResponse.get();
            }
            catch (IOException | ClassNotFoundException | InterruptedException | ExecutionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
            }
        }
        LOG.trace("Added an Exchange with ID {} for key {} in optimistic manner.", (Object)newExchange.getExchangeId(), (Object)key);
        return oldExchange;
    }

    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        if (this.optimistic) {
            throw new UnsupportedOperationException();
        }
        LOG.trace("Adding an Exchange with ID {} for key {} in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
        DefaultExchangeHolder newHolder = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)true, (boolean)this.allowSerializedHeaders);
        CompletableFuture completableResponse = this.kvClient.get(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()));
        try {
            GetResponse getResponse = (GetResponse)completableResponse.get();
            long modRevision = 0L;
            if (!getResponse.getKvs().isEmpty()) {
                modRevision = ((KeyValue)getResponse.getKvs().get(0)).getModRevision();
            }
            Txn transaction = this.kvClient.txn();
            transaction.If(new Cmp[]{new Cmp(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()), Cmp.Op.EQUAL, (CmpTarget)CmpTarget.modRevision((long)modRevision))}).Then(new Op[]{Op.put((ByteSequence)ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()), (ByteSequence)this.convertToEtcd3Format(newHolder), (PutOption)PutOption.DEFAULT)}).commit().get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
        }
        return this.unmarshallExchange(camelContext, newHolder);
    }

    public Set<String> scan(CamelContext camelContext) {
        if (this.useRecovery) {
            LOG.trace("Scanning for exchanges to recover in {} context", (Object)camelContext.getName());
            CompletableFuture completableGetResponse = this.kvClient.get(ByteSequence.from((byte[])this.persistencePrefixName.getBytes()), GetOption.newBuilder().withPrefix(ByteSequence.from((byte[])this.persistencePrefixName.getBytes())).build());
            try {
                GetResponse getResponse = (GetResponse)completableGetResponse.get();
                TreeSet keys = new TreeSet();
                getResponse.getKvs().forEach(kv -> keys.add(new String(kv.getKey().getBytes())));
                Set<String> scanned = Collections.unmodifiableSet(keys);
                LOG.trace("Found {} keys for exchanges to recover in {} context", (Object)scanned.size(), (Object)camelContext.getName());
                return scanned;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
            }
        }
        LOG.warn("What for to run recovery scans in {} context while prefix {} is running in non-recoverable aggregation repository mode?!", (Object)camelContext.getName(), (Object)this.prefixName);
        return Collections.emptySet();
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        LOG.trace("Recovering an Exchange with ID {}.", (Object)exchangeId);
        CompletableFuture completableResponse = this.kvClient.get(ByteSequence.from((byte[])String.format("%s/%s", this.persistencePrefixName, exchangeId).getBytes()));
        try {
            GetResponse getResponse = (GetResponse)completableResponse.get();
            DefaultExchangeHolder holder = (DefaultExchangeHolder)this.convertFromEtcd3Format(((KeyValue)getResponse.getKvs().get(0)).getValue());
            return this.useRecovery ? this.unmarshallExchange(camelContext, holder) : null;
        }
        catch (IOException | ClassNotFoundException | InterruptedException | ExecutionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
        }
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterChannel = deadLetterUri;
    }

    public String getDeadLetterUri() {
        return this.deadLetterChannel;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public boolean isOptimistic() {
        return this.optimistic;
    }

    public void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getPrefixName() {
        return this.prefixName;
    }

    public void setPrefixName(String prefixName) {
        this.prefixName = prefixName;
    }

    public Exchange get(CamelContext camelContext, String key) {
        CompletableFuture completableResponse = this.kvClient.get(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()));
        try {
            GetResponse getResponse = (GetResponse)completableResponse.get();
            DefaultExchangeHolder holder = null;
            if (!getResponse.getKvs().isEmpty()) {
                holder = (DefaultExchangeHolder)this.convertFromEtcd3Format(((KeyValue)getResponse.getKvs().get(0)).getValue());
            }
            return this.unmarshallExchange(camelContext, holder);
        }
        catch (IOException | ClassNotFoundException | InterruptedException | ExecutionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
        }
    }

    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)true, (boolean)this.allowSerializedHeaders);
        if (this.optimistic) {
            LOG.trace("Removing an exchange with ID {} for key {} in an optimistic manner.", (Object)exchange.getExchangeId(), (Object)key);
            try {
                CompletableFuture completableGetResponse = this.kvClient.get(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()));
                GetResponse getResponse = (GetResponse)completableGetResponse.get();
                List keyValueList = getResponse.getKvs();
                boolean optimisticLockingError = keyValueList.isEmpty();
                if (!optimisticLockingError) {
                    DefaultExchangeHolder holderFound = (DefaultExchangeHolder)this.convertFromEtcd3Format(((KeyValue)keyValueList.get(0)).getValue());
                    boolean bl = optimisticLockingError = !Objects.equals(holder, holderFound);
                    if (!optimisticLockingError) {
                        CompletableFuture completableDeleteResponse = this.kvClient.delete(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()));
                        DeleteResponse deleteResponse = (DeleteResponse)completableDeleteResponse.get();
                        boolean bl2 = optimisticLockingError = deleteResponse.getDeleted() == 0L;
                    }
                }
                if (optimisticLockingError) {
                    LOG.warn("Optimistic locking failed for exchange with key {}: kvClient.delete removed no Exchanges, while it's expected to remove one.", (Object)key);
                    throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
                }
            }
            catch (IOException | ClassNotFoundException | InterruptedException | ExecutionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
            }
            LOG.trace("Removed an exchange with ID {} for key {} in an optimistic manner.", (Object)exchange.getExchangeId(), (Object)key);
            if (this.useRecovery) {
                LOG.trace("Putting an exchange with ID {} for key {} into a recoverable storage in an optimistic manner.", (Object)exchange.getExchangeId(), (Object)key);
                try {
                    CompletableFuture completablePutResponse = this.kvClient.put(ByteSequence.from((byte[])String.format("%s/%s", this.persistencePrefixName, key).getBytes()), this.convertToEtcd3Format(holder));
                    completablePutResponse.get();
                    LOG.trace("Put an exchange with ID {} for key {} into a recoverable storage in an optimistic manner.", (Object)exchange.getExchangeId(), (Object)key);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            if (this.useRecovery) {
                LOG.trace("Removing an exchange with ID {} for key {} in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
                Txn transaction = this.kvClient.txn();
                try {
                    CompletableFuture completableResponse = this.kvClient.get(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()));
                    GetResponse getResponse = (GetResponse)completableResponse.get();
                    DefaultExchangeHolder removedHolder = (DefaultExchangeHolder)this.convertFromEtcd3Format(((KeyValue)getResponse.getKvs().get(0)).getValue());
                    transaction.If(new Cmp[]{new Cmp(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()), Cmp.Op.EQUAL, (CmpTarget)CmpTarget.value((ByteSequence)ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes())))}).Then(new Op[]{Op.delete((ByteSequence)ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()), (DeleteOption)DeleteOption.DEFAULT), Op.put((ByteSequence)ByteSequence.from((byte[])String.format("%s/%s", this.persistencePrefixName, key).getBytes()), (ByteSequence)this.convertToEtcd3Format(removedHolder), (PutOption)PutOption.DEFAULT)}).commit().get();
                    LOG.trace("Removed an exchange with ID {} for key {} in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
                    LOG.trace("Put an exchange with ID {} for key {} into a recoverable storage in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
                }
                catch (Exception exception) {
                    throw new RuntimeCamelException(exception.getMessage(), (Throwable)exception);
                }
            }
            CompletableFuture completableDeleteResponse = this.kvClient.delete(ByteSequence.from((byte[])String.format("%s/%s", this.prefixName, key).getBytes()));
            try {
                completableDeleteResponse.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void confirm(CamelContext camelContext, String exchangeId) {
        LOG.trace("Confirming an exchange with ID {}.", (Object)exchangeId);
        if (this.useRecovery) {
            CompletableFuture completableDeleteResponse = this.kvClient.delete(ByteSequence.from((byte[])String.format("%s/%s", this.persistencePrefixName, exchangeId).getBytes()));
            try {
                completableDeleteResponse.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Set<String> getKeys() {
        Set<String> scanned;
        CompletableFuture completableGetResponse = this.kvClient.get(ByteSequence.from((byte[])this.prefixName.getBytes()), GetOption.newBuilder().withRange(ByteSequence.from((byte[])this.prefixName.getBytes())).build());
        try {
            GetResponse getResponse = (GetResponse)completableGetResponse.get();
            TreeSet keys = new TreeSet();
            getResponse.getKvs().forEach(kv -> keys.add(new String(kv.getKey().getBytes())));
            scanned = Collections.unmodifiableSet(keys);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
        }
        return scanned;
    }

    protected void doInit() throws Exception {
        StringHelper.notEmpty((String)this.prefixName, (String)"prefixName");
        if (this.maximumRedeliveries < 0) {
            throw new IllegalArgumentException("Maximum redelivery retries must be zero or a positive integer.");
        }
        if (this.recoveryInterval < 0L) {
            throw new IllegalArgumentException("Recovery interval must be zero or a positive integer.");
        }
    }

    protected void doStart() {
        if (this.client == null) {
            this.client = Client.builder().endpoints(new String[]{this.endpoint}).build();
            this.shutdownClient = true;
        }
        this.kvClient = this.client.getKVClient();
    }

    protected void doStop() throws Exception {
        if (this.client != null && this.shutdownClient) {
            this.client.close();
            this.client = null;
        }
    }

    protected Exchange unmarshallExchange(CamelContext camelContext, DefaultExchangeHolder holder) {
        DefaultExchange exchange = null;
        if (holder != null) {
            exchange = new DefaultExchange(camelContext);
            DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        }
        return exchange;
    }

    private Object convertFromEtcd3Format(ByteSequence value) throws IOException, ClassNotFoundException {
        byte[] data = value.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private ByteSequence convertToEtcd3Format(Object value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.flush();
            return ByteSequence.from((byte[])bos.toByteArray());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

