/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import org.apache.camel.CamelContext;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdKeysComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class EtcdKeysComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private EtcdConfiguration getOrCreateConfiguration(EtcdKeysComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new EtcdConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        EtcdKeysComponent target = (EtcdKeysComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((EtcdConfiguration)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, EtcdConfiguration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "recursive": {
                this.getOrCreateConfiguration(target).setRecursive((Boolean)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "servicepath": 
            case "servicePath": {
                this.getOrCreateConfiguration(target).setServicePath((String)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters((SSLContextParameters)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "timetolive": 
            case "timeToLive": {
                this.getOrCreateConfiguration(target).setTimeToLive((Integer)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "timeout": {
                this.getOrCreateConfiguration(target).setTimeout((Long)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "uris": {
                this.getOrCreateConfiguration(target).setUris((String)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters((Boolean)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": 
            case "userName": {
                this.getOrCreateConfiguration(target).setUserName((String)EtcdKeysComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return EtcdConfiguration.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "recursive": {
                return Boolean.TYPE;
            }
            case "servicepath": 
            case "servicePath": {
                return String.class;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "timetolive": 
            case "timeToLive": {
                return Integer.class;
            }
            case "timeout": {
                return Long.class;
            }
            case "uris": {
                return String.class;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return Boolean.TYPE;
            }
            case "username": 
            case "userName": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        EtcdKeysComponent target = (EtcdKeysComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "recursive": {
                return this.getOrCreateConfiguration(target).isRecursive();
            }
            case "servicepath": 
            case "servicePath": {
                return this.getOrCreateConfiguration(target).getServicePath();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "timetolive": 
            case "timeToLive": {
                return this.getOrCreateConfiguration(target).getTimeToLive();
            }
            case "timeout": {
                return this.getOrCreateConfiguration(target).getTimeout();
            }
            case "uris": {
                return this.getOrCreateConfiguration(target).getUris();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "username": 
            case "userName": {
                return this.getOrCreateConfiguration(target).getUserName();
            }
        }
        return null;
    }
}

