/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import io.minio.MinioClient;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.minio.MinioOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public interface MinioEndpointBuilderFactory {
    public static MinioEndpointBuilder endpointBuilder(String componentName, String path) {
        class MinioEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements MinioEndpointBuilder,
        AdvancedMinioEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public MinioEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new MinioEndpointBuilderImpl(path, componentName);
    }

    public static class MinioHeaderNameBuilder {
        private static final MinioHeaderNameBuilder INSTANCE = new MinioHeaderNameBuilder();

        public String minioBucketName() {
            return "CamelMinioBucketName";
        }

        public String minioDestinationBucketName() {
            return "CamelMinioDestinationBucketName";
        }

        public String minioContentControl() {
            return "CamelMinioContentControl";
        }

        public String minioContentDisposition() {
            return "CamelMinioContentDisposition";
        }

        public String minioContentEncoding() {
            return "CamelMinioContentEncoding";
        }

        public String minioContentLength() {
            return "CamelMinioContentLength";
        }

        public String minioContentMD5() {
            return "CamelMinioContentMD5";
        }

        public String minioContentType() {
            return "CamelMinioContentType";
        }

        public String minioETag() {
            return "CamelMinioETag";
        }

        public String minioObjectName() {
            return "CamelMinioObjectName";
        }

        public String minioDestinationObjectName() {
            return "CamelMinioDestinationObjectName";
        }

        public String minioLastModified() {
            return "CamelMinioLastModified";
        }

        public String minioStorageClass() {
            return "CamelMinioStorageClass";
        }

        public String minioVersionId() {
            return "CamelMinioVersionId";
        }

        public String minioCannedAcl() {
            return "CamelMinioCannedAcl";
        }

        public String minioOperation() {
            return "CamelMinioOperation";
        }

        public String minioServerSideEncryption() {
            return "CamelMinioServerSideEncryption";
        }

        public String minioExpirationTime() {
            return "CamelMinioExpirationTime";
        }

        public String minioReplicationStatus() {
            return "CamelMinioReplicationStatus";
        }

        public String minioOffset() {
            return "CamelMinioOffset";
        }

        public String minioLength() {
            return "CamelMinioLength";
        }

        public String minioPresignedURLExpirationTime() {
            return "CamelMinioPresignedURLExpirationTime";
        }
    }

    public static interface MinioBuilders {
        default public MinioHeaderNameBuilder minio() {
            return MinioHeaderNameBuilder.INSTANCE;
        }

        default public MinioEndpointBuilder minio(String path) {
            return MinioEndpointBuilderFactory.endpointBuilder("minio", path);
        }

        default public MinioEndpointBuilder minio(String componentName, String path) {
            return MinioEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedMinioEndpointBuilder
    extends AdvancedMinioEndpointConsumerBuilder,
    AdvancedMinioEndpointProducerBuilder {
        @Override
        default public MinioEndpointBuilder basic() {
            return (MinioEndpointBuilder)((Object)this);
        }
    }

    public static interface MinioEndpointBuilder
    extends MinioEndpointConsumerBuilder,
    MinioEndpointProducerBuilder {
        @Override
        default public AdvancedMinioEndpointBuilder advanced() {
            return (AdvancedMinioEndpointBuilder)((Object)this);
        }

        @Override
        default public MinioEndpointBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        @Override
        default public MinioEndpointBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        @Override
        default public MinioEndpointBuilder customHttpClient(OkHttpClient customHttpClient) {
            this.doSetProperty("customHttpClient", customHttpClient);
            return this;
        }

        @Override
        default public MinioEndpointBuilder customHttpClient(String customHttpClient) {
            this.doSetProperty("customHttpClient", customHttpClient);
            return this;
        }

        @Override
        default public MinioEndpointBuilder endpoint(String endpoint) {
            this.doSetProperty("endpoint", endpoint);
            return this;
        }

        @Override
        default public MinioEndpointBuilder minioClient(MinioClient minioClient) {
            this.doSetProperty("minioClient", minioClient);
            return this;
        }

        @Override
        default public MinioEndpointBuilder minioClient(String minioClient) {
            this.doSetProperty("minioClient", minioClient);
            return this;
        }

        @Override
        default public MinioEndpointBuilder objectLock(boolean objectLock) {
            this.doSetProperty("objectLock", objectLock);
            return this;
        }

        @Override
        default public MinioEndpointBuilder objectLock(String objectLock) {
            this.doSetProperty("objectLock", objectLock);
            return this;
        }

        @Override
        default public MinioEndpointBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        @Override
        default public MinioEndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        @Override
        default public MinioEndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        @Override
        default public MinioEndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        @Override
        default public MinioEndpointBuilder secure(boolean secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        @Override
        default public MinioEndpointBuilder secure(String secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        @Override
        default public MinioEndpointBuilder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        @Override
        default public MinioEndpointBuilder serverSideEncryption(String serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        @Override
        default public MinioEndpointBuilder serverSideEncryptionCustomerKey(ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey) {
            this.doSetProperty("serverSideEncryptionCustomerKey", serverSideEncryptionCustomerKey);
            return this;
        }

        @Override
        default public MinioEndpointBuilder serverSideEncryptionCustomerKey(String serverSideEncryptionCustomerKey) {
            this.doSetProperty("serverSideEncryptionCustomerKey", serverSideEncryptionCustomerKey);
            return this;
        }

        @Override
        default public MinioEndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        @Override
        default public MinioEndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    public static interface AdvancedMinioEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public MinioEndpointProducerBuilder basic() {
            return (MinioEndpointProducerBuilder)((Object)this);
        }

        default public AdvancedMinioEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedMinioEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface MinioEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedMinioEndpointProducerBuilder advanced() {
            return (AdvancedMinioEndpointProducerBuilder)((Object)this);
        }

        default public MinioEndpointProducerBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public MinioEndpointProducerBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public MinioEndpointProducerBuilder customHttpClient(OkHttpClient customHttpClient) {
            this.doSetProperty("customHttpClient", customHttpClient);
            return this;
        }

        default public MinioEndpointProducerBuilder customHttpClient(String customHttpClient) {
            this.doSetProperty("customHttpClient", customHttpClient);
            return this;
        }

        default public MinioEndpointProducerBuilder endpoint(String endpoint) {
            this.doSetProperty("endpoint", endpoint);
            return this;
        }

        default public MinioEndpointProducerBuilder minioClient(MinioClient minioClient) {
            this.doSetProperty("minioClient", minioClient);
            return this;
        }

        default public MinioEndpointProducerBuilder minioClient(String minioClient) {
            this.doSetProperty("minioClient", minioClient);
            return this;
        }

        default public MinioEndpointProducerBuilder objectLock(boolean objectLock) {
            this.doSetProperty("objectLock", objectLock);
            return this;
        }

        default public MinioEndpointProducerBuilder objectLock(String objectLock) {
            this.doSetProperty("objectLock", objectLock);
            return this;
        }

        default public MinioEndpointProducerBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public MinioEndpointProducerBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MinioEndpointProducerBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MinioEndpointProducerBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public MinioEndpointProducerBuilder secure(boolean secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        default public MinioEndpointProducerBuilder secure(String secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        default public MinioEndpointProducerBuilder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        default public MinioEndpointProducerBuilder serverSideEncryption(String serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        default public MinioEndpointProducerBuilder serverSideEncryptionCustomerKey(ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey) {
            this.doSetProperty("serverSideEncryptionCustomerKey", serverSideEncryptionCustomerKey);
            return this;
        }

        default public MinioEndpointProducerBuilder serverSideEncryptionCustomerKey(String serverSideEncryptionCustomerKey) {
            this.doSetProperty("serverSideEncryptionCustomerKey", serverSideEncryptionCustomerKey);
            return this;
        }

        default public MinioEndpointProducerBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public MinioEndpointProducerBuilder deleteAfterWrite(String deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public MinioEndpointProducerBuilder keyName(String keyName) {
            this.doSetProperty("keyName", keyName);
            return this;
        }

        default public MinioEndpointProducerBuilder operation(MinioOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public MinioEndpointProducerBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public MinioEndpointProducerBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public MinioEndpointProducerBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public MinioEndpointProducerBuilder storageClass(String storageClass) {
            this.doSetProperty("storageClass", storageClass);
            return this;
        }

        default public MinioEndpointProducerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public MinioEndpointProducerBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    public static interface AdvancedMinioEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public MinioEndpointConsumerBuilder basic() {
            return (MinioEndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedMinioEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedMinioEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedMinioEndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedMinioEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedMinioEndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedMinioEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedMinioEndpointConsumerBuilder pollStrategy(PollingConsumerPollStrategy pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedMinioEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    public static interface MinioEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedMinioEndpointConsumerBuilder advanced() {
            return (AdvancedMinioEndpointConsumerBuilder)((Object)this);
        }

        default public MinioEndpointConsumerBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public MinioEndpointConsumerBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public MinioEndpointConsumerBuilder customHttpClient(OkHttpClient customHttpClient) {
            this.doSetProperty("customHttpClient", customHttpClient);
            return this;
        }

        default public MinioEndpointConsumerBuilder customHttpClient(String customHttpClient) {
            this.doSetProperty("customHttpClient", customHttpClient);
            return this;
        }

        default public MinioEndpointConsumerBuilder endpoint(String endpoint) {
            this.doSetProperty("endpoint", endpoint);
            return this;
        }

        default public MinioEndpointConsumerBuilder minioClient(MinioClient minioClient) {
            this.doSetProperty("minioClient", minioClient);
            return this;
        }

        default public MinioEndpointConsumerBuilder minioClient(String minioClient) {
            this.doSetProperty("minioClient", minioClient);
            return this;
        }

        default public MinioEndpointConsumerBuilder objectLock(boolean objectLock) {
            this.doSetProperty("objectLock", objectLock);
            return this;
        }

        default public MinioEndpointConsumerBuilder objectLock(String objectLock) {
            this.doSetProperty("objectLock", objectLock);
            return this;
        }

        default public MinioEndpointConsumerBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public MinioEndpointConsumerBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MinioEndpointConsumerBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MinioEndpointConsumerBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public MinioEndpointConsumerBuilder secure(boolean secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        default public MinioEndpointConsumerBuilder secure(String secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        default public MinioEndpointConsumerBuilder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        default public MinioEndpointConsumerBuilder serverSideEncryption(String serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        default public MinioEndpointConsumerBuilder serverSideEncryptionCustomerKey(ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey) {
            this.doSetProperty("serverSideEncryptionCustomerKey", serverSideEncryptionCustomerKey);
            return this;
        }

        default public MinioEndpointConsumerBuilder serverSideEncryptionCustomerKey(String serverSideEncryptionCustomerKey) {
            this.doSetProperty("serverSideEncryptionCustomerKey", serverSideEncryptionCustomerKey);
            return this;
        }

        default public MinioEndpointConsumerBuilder autoCloseBody(boolean autoCloseBody) {
            this.doSetProperty("autoCloseBody", autoCloseBody);
            return this;
        }

        default public MinioEndpointConsumerBuilder autoCloseBody(String autoCloseBody) {
            this.doSetProperty("autoCloseBody", autoCloseBody);
            return this;
        }

        default public MinioEndpointConsumerBuilder bypassGovernanceMode(boolean bypassGovernanceMode) {
            this.doSetProperty("bypassGovernanceMode", bypassGovernanceMode);
            return this;
        }

        default public MinioEndpointConsumerBuilder bypassGovernanceMode(String bypassGovernanceMode) {
            this.doSetProperty("bypassGovernanceMode", bypassGovernanceMode);
            return this;
        }

        default public MinioEndpointConsumerBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public MinioEndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public MinioEndpointConsumerBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public MinioEndpointConsumerBuilder destinationBucketName(String destinationBucketName) {
            this.doSetProperty("destinationBucketName", destinationBucketName);
            return this;
        }

        default public MinioEndpointConsumerBuilder destinationObjectName(String destinationObjectName) {
            this.doSetProperty("destinationObjectName", destinationObjectName);
            return this;
        }

        default public MinioEndpointConsumerBuilder includeBody(boolean includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public MinioEndpointConsumerBuilder includeBody(String includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public MinioEndpointConsumerBuilder includeFolders(boolean includeFolders) {
            this.doSetProperty("includeFolders", includeFolders);
            return this;
        }

        default public MinioEndpointConsumerBuilder includeFolders(String includeFolders) {
            this.doSetProperty("includeFolders", includeFolders);
            return this;
        }

        default public MinioEndpointConsumerBuilder includeUserMetadata(boolean includeUserMetadata) {
            this.doSetProperty("includeUserMetadata", includeUserMetadata);
            return this;
        }

        default public MinioEndpointConsumerBuilder includeUserMetadata(String includeUserMetadata) {
            this.doSetProperty("includeUserMetadata", includeUserMetadata);
            return this;
        }

        default public MinioEndpointConsumerBuilder includeVersions(boolean includeVersions) {
            this.doSetProperty("includeVersions", includeVersions);
            return this;
        }

        default public MinioEndpointConsumerBuilder includeVersions(String includeVersions) {
            this.doSetProperty("includeVersions", includeVersions);
            return this;
        }

        default public MinioEndpointConsumerBuilder length(long length) {
            this.doSetProperty("length", length);
            return this;
        }

        default public MinioEndpointConsumerBuilder length(String length) {
            this.doSetProperty("length", length);
            return this;
        }

        default public MinioEndpointConsumerBuilder matchETag(String matchETag) {
            this.doSetProperty("matchETag", matchETag);
            return this;
        }

        default public MinioEndpointConsumerBuilder maxConnections(int maxConnections) {
            this.doSetProperty("maxConnections", maxConnections);
            return this;
        }

        default public MinioEndpointConsumerBuilder maxConnections(String maxConnections) {
            this.doSetProperty("maxConnections", maxConnections);
            return this;
        }

        default public MinioEndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public MinioEndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public MinioEndpointConsumerBuilder modifiedSince(ZonedDateTime modifiedSince) {
            this.doSetProperty("modifiedSince", modifiedSince);
            return this;
        }

        default public MinioEndpointConsumerBuilder modifiedSince(String modifiedSince) {
            this.doSetProperty("modifiedSince", modifiedSince);
            return this;
        }

        default public MinioEndpointConsumerBuilder moveAfterRead(boolean moveAfterRead) {
            this.doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }

        default public MinioEndpointConsumerBuilder moveAfterRead(String moveAfterRead) {
            this.doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }

        default public MinioEndpointConsumerBuilder notMatchETag(String notMatchETag) {
            this.doSetProperty("notMatchETag", notMatchETag);
            return this;
        }

        default public MinioEndpointConsumerBuilder objectName(String objectName) {
            this.doSetProperty("objectName", objectName);
            return this;
        }

        default public MinioEndpointConsumerBuilder offset(long offset) {
            this.doSetProperty("offset", offset);
            return this;
        }

        default public MinioEndpointConsumerBuilder offset(String offset) {
            this.doSetProperty("offset", offset);
            return this;
        }

        default public MinioEndpointConsumerBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public MinioEndpointConsumerBuilder recursive(boolean recursive) {
            this.doSetProperty("recursive", recursive);
            return this;
        }

        default public MinioEndpointConsumerBuilder recursive(String recursive) {
            this.doSetProperty("recursive", recursive);
            return this;
        }

        default public MinioEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public MinioEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public MinioEndpointConsumerBuilder startAfter(String startAfter) {
            this.doSetProperty("startAfter", startAfter);
            return this;
        }

        default public MinioEndpointConsumerBuilder unModifiedSince(ZonedDateTime unModifiedSince) {
            this.doSetProperty("unModifiedSince", unModifiedSince);
            return this;
        }

        default public MinioEndpointConsumerBuilder unModifiedSince(String unModifiedSince) {
            this.doSetProperty("unModifiedSince", unModifiedSince);
            return this;
        }

        default public MinioEndpointConsumerBuilder useVersion1(boolean useVersion1) {
            this.doSetProperty("useVersion1", useVersion1);
            return this;
        }

        default public MinioEndpointConsumerBuilder useVersion1(String useVersion1) {
            this.doSetProperty("useVersion1", useVersion1);
            return this;
        }

        default public MinioEndpointConsumerBuilder versionId(String versionId) {
            this.doSetProperty("versionId", versionId);
            return this;
        }

        default public MinioEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public MinioEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public MinioEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public MinioEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public MinioEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public MinioEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public MinioEndpointConsumerBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public MinioEndpointConsumerBuilder delay(String delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public MinioEndpointConsumerBuilder greedy(boolean greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public MinioEndpointConsumerBuilder greedy(String greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public MinioEndpointConsumerBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public MinioEndpointConsumerBuilder initialDelay(String initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public MinioEndpointConsumerBuilder repeatCount(long repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public MinioEndpointConsumerBuilder repeatCount(String repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public MinioEndpointConsumerBuilder runLoggingLevel(LoggingLevel runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public MinioEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public MinioEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public MinioEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public MinioEndpointConsumerBuilder scheduler(Object scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public MinioEndpointConsumerBuilder scheduler(String scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public MinioEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            this.doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }

        default public MinioEndpointConsumerBuilder schedulerProperties(Map values) {
            this.doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }

        default public MinioEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public MinioEndpointConsumerBuilder startScheduler(String startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public MinioEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            this.doSetProperty("timeUnit", (Object)timeUnit);
            return this;
        }

        default public MinioEndpointConsumerBuilder timeUnit(String timeUnit) {
            this.doSetProperty("timeUnit", timeUnit);
            return this;
        }

        default public MinioEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public MinioEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public MinioEndpointConsumerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public MinioEndpointConsumerBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

