/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.firehose.FirehoseClient;

public interface KinesisFirehose2EndpointBuilderFactory {
    public static KinesisFirehose2EndpointBuilder endpointBuilder(String componentName, String path) {
        class KinesisFirehose2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements KinesisFirehose2EndpointBuilder,
        AdvancedKinesisFirehose2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public KinesisFirehose2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new KinesisFirehose2EndpointBuilderImpl(path, componentName);
    }

    public static class KinesisFirehose2HeaderNameBuilder {
        private static final KinesisFirehose2HeaderNameBuilder INSTANCE = new KinesisFirehose2HeaderNameBuilder();

        public String awsKinesisFirehoseRecordId() {
            return "CamelAwsKinesisFirehoseRecordId";
        }

        public String awsKinesisFirehoseOperation() {
            return "CamelAwsKinesisFirehoseOperation";
        }

        public String awsKinesisFirehoseDeliveryStreamName() {
            return "CamelAwsKinesisFirehoseDeliveryStreamName";
        }
    }

    public static interface KinesisFirehose2Builders {
        default public KinesisFirehose2HeaderNameBuilder aws2KinesisFirehose() {
            return KinesisFirehose2HeaderNameBuilder.INSTANCE;
        }

        default public KinesisFirehose2EndpointBuilder aws2KinesisFirehose(String path) {
            return KinesisFirehose2EndpointBuilderFactory.endpointBuilder("aws2-kinesis-firehose", path);
        }

        default public KinesisFirehose2EndpointBuilder aws2KinesisFirehose(String componentName, String path) {
            return KinesisFirehose2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedKinesisFirehose2EndpointBuilder
    extends EndpointProducerBuilder {
        default public KinesisFirehose2EndpointBuilder basic() {
            return (KinesisFirehose2EndpointBuilder)((Object)this);
        }

        default public AdvancedKinesisFirehose2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedKinesisFirehose2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface KinesisFirehose2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedKinesisFirehose2EndpointBuilder advanced() {
            return (AdvancedKinesisFirehose2EndpointBuilder)((Object)this);
        }

        default public KinesisFirehose2EndpointBuilder amazonKinesisFirehoseClient(FirehoseClient amazonKinesisFirehoseClient) {
            this.doSetProperty("amazonKinesisFirehoseClient", amazonKinesisFirehoseClient);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder amazonKinesisFirehoseClient(String amazonKinesisFirehoseClient) {
            this.doSetProperty("amazonKinesisFirehoseClient", amazonKinesisFirehoseClient);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder cborEnabled(boolean cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder cborEnabled(String cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder operation(KinesisFirehose2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public KinesisFirehose2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

