/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Expose websocket endpoints using Jetty.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WebsocketEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Jetty Websocket component.
     */
    public interface WebsocketEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWebsocketEndpointConsumerBuilder advanced() {
            return (AdvancedWebsocketEndpointConsumerBuilder) this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maxBinaryMessageSize the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder maxBinaryMessageSize(
                Integer maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maxBinaryMessageSize the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder maxBinaryMessageSize(
                String maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Whether to enable session support which enables HttpSession for each
         * http request.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sessionSupport the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder sessionSupport(
                boolean sessionSupport) {
            doSetProperty("sessionSupport", sessionSupport);
            return this;
        }
        /**
         * Whether to enable session support which enables HttpSession for each
         * http request.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sessionSupport the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder sessionSupport(
                String sessionSupport) {
            doSetProperty("sessionSupport", sessionSupport);
            return this;
        }
        /**
         * Set a resource path for static resources (such as .html files etc).
         * The resources can be loaded from classpath, if you prefix with
         * classpath:, otherwise the resources is loaded from file system or
         * from JAR files. For example to load from root classpath use
         * classpath:., or classpath:WEB-INF/static If not configured (eg null)
         * then no static resource is in use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param staticResources the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder staticResources(
                String staticResources) {
            doSetProperty("staticResources", staticResources);
            return this;
        }
        /**
         * This is a comma-separated list of subprotocols that are supported by
         * the application. The list is in priority order. The first subprotocol
         * on this list that is proposed by the client is the one that will be
         * accepted. If no subprotocol on this list is proposed by the client,
         * then the websocket connection is refused. The special value 'any'
         * means that any subprotocol is acceptable. 'any' can be used on its
         * own, or as a failsafe at the end of a list of more specific
         * protocols. 'any' will also match the case where no subprotocol is
         * proposed by the client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: any
         * Group: consumer
         * 
         * @param subprotocol the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder subprotocol(String subprotocol) {
            doSetProperty("subprotocol", subprotocol);
            return this;
        }
        /**
         * The CORS allowed origins. Use to allow all.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: cors
         * 
         * @param allowedOrigins the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder allowedOrigins(
                String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: cors
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: cors
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Context path for filtering CORS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: cors
         * 
         * @param filterPath the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: monitoring
         * 
         * @param enableJmx the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder enableJmx(boolean enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: monitoring
         * 
         * @param enableJmx the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder enableJmx(String enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Jetty Websocket
     * component.
     */
    public interface AdvancedWebsocketEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default WebsocketEndpointConsumerBuilder basic() {
            return (WebsocketEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder bufferSize(
                Integer bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder bufferSize(
                String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param maxIdleTime the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder maxIdleTime(
                Integer maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param maxIdleTime the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder maxIdleTime(
                String maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxTextMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder maxTextMessageSize(
                Integer maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxTextMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder maxTextMessageSize(
                String maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 13
         * Group: advanced
         * 
         * @param minVersion the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder minVersion(
                Integer minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 13
         * Group: advanced
         * 
         * @param minVersion the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointConsumerBuilder minVersion(
                String minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Jetty Websocket component.
     */
    public interface WebsocketEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWebsocketEndpointProducerBuilder advanced() {
            return (AdvancedWebsocketEndpointProducerBuilder) this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maxBinaryMessageSize the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder maxBinaryMessageSize(
                Integer maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maxBinaryMessageSize the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder maxBinaryMessageSize(
                String maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Timeout in millis when sending to a websocket channel. The default
         * timeout is 30000 (30 seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param sendTimeout the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder sendTimeout(Integer sendTimeout) {
            doSetProperty("sendTimeout", sendTimeout);
            return this;
        }
        /**
         * Timeout in millis when sending to a websocket channel. The default
         * timeout is 30000 (30 seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param sendTimeout the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder sendTimeout(String sendTimeout) {
            doSetProperty("sendTimeout", sendTimeout);
            return this;
        }
        /**
         * To send to all websocket subscribers. Can be used to configure on
         * endpoint level, instead of having to use the
         * WebsocketConstants.SEND_TO_ALL header on the message.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param sendToAll the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder sendToAll(Boolean sendToAll) {
            doSetProperty("sendToAll", sendToAll);
            return this;
        }
        /**
         * To send to all websocket subscribers. Can be used to configure on
         * endpoint level, instead of having to use the
         * WebsocketConstants.SEND_TO_ALL header on the message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param sendToAll the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder sendToAll(String sendToAll) {
            doSetProperty("sendToAll", sendToAll);
            return this;
        }
        /**
         * The CORS allowed origins. Use to allow all.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: cors
         * 
         * @param allowedOrigins the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder allowedOrigins(
                String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: cors
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: cors
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Context path for filtering CORS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: cors
         * 
         * @param filterPath the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: monitoring
         * 
         * @param enableJmx the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder enableJmx(boolean enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: monitoring
         * 
         * @param enableJmx the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder enableJmx(String enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Jetty Websocket
     * component.
     */
    public interface AdvancedWebsocketEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default WebsocketEndpointProducerBuilder basic() {
            return (WebsocketEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder bufferSize(
                Integer bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder bufferSize(
                String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param maxIdleTime the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder maxIdleTime(
                Integer maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param maxIdleTime the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder maxIdleTime(
                String maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxTextMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder maxTextMessageSize(
                Integer maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxTextMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder maxTextMessageSize(
                String maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 13
         * Group: advanced
         * 
         * @param minVersion the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder minVersion(
                Integer minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 13
         * Group: advanced
         * 
         * @param minVersion the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointProducerBuilder minVersion(
                String minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Jetty Websocket component.
     */
    public interface WebsocketEndpointBuilder
            extends
                WebsocketEndpointConsumerBuilder,
                WebsocketEndpointProducerBuilder {
        default AdvancedWebsocketEndpointBuilder advanced() {
            return (AdvancedWebsocketEndpointBuilder) this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maxBinaryMessageSize the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder maxBinaryMessageSize(
                Integer maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maxBinaryMessageSize the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder maxBinaryMessageSize(
                String maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * The CORS allowed origins. Use to allow all.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: cors
         * 
         * @param allowedOrigins the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder allowedOrigins(String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: cors
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: cors
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Context path for filtering CORS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: cors
         * 
         * @param filterPath the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: monitoring
         * 
         * @param enableJmx the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder enableJmx(boolean enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: monitoring
         * 
         * @param enableJmx the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder enableJmx(String enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Jetty Websocket component.
     */
    public interface AdvancedWebsocketEndpointBuilder
            extends
                AdvancedWebsocketEndpointConsumerBuilder,
                AdvancedWebsocketEndpointProducerBuilder {
        default WebsocketEndpointBuilder basic() {
            return (WebsocketEndpointBuilder) this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointBuilder bufferSize(Integer bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param maxIdleTime the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointBuilder maxIdleTime(Integer maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param maxIdleTime the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointBuilder maxIdleTime(String maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxTextMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointBuilder maxTextMessageSize(
                Integer maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxTextMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointBuilder maxTextMessageSize(
                String maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 13
         * Group: advanced
         * 
         * @param minVersion the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointBuilder minVersion(Integer minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 13
         * Group: advanced
         * 
         * @param minVersion the value to set
         * @return the dsl builder
         */
        default AdvancedWebsocketEndpointBuilder minVersion(String minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
    }

    public interface WebsocketBuilders {
        /**
         * Jetty Websocket (camel-websocket)
         * Expose websocket endpoints using Jetty.
         * 
         * Category: websocket
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-websocket
         * 
         * @return the dsl builder for the headers' name.
         */
        default WebsocketHeaderNameBuilder websocket() {
            return WebsocketHeaderNameBuilder.INSTANCE;
        }
        /**
         * Jetty Websocket (camel-websocket)
         * Expose websocket endpoints using Jetty.
         * 
         * Category: websocket
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-websocket
         * 
         * Syntax: <code>websocket:host:port/resourceUri</code>
         * 
         * Path parameter: host
         * The hostname. The default value is 0.0.0.0. Setting this option on
         * the component will use the component configured value as default.
         * Default value: 0.0.0.0
         * 
         * Path parameter: port
         * The port number. The default value is 9292. Setting this option on
         * the component will use the component configured value as default.
         * Default value: 9292
         * 
         * Path parameter: resourceUri (required)
         * Name of the websocket channel to use
         * 
         * @param path host:port/resourceUri
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder websocket(String path) {
            return WebsocketEndpointBuilderFactory.endpointBuilder("websocket", path);
        }
        /**
         * Jetty Websocket (camel-websocket)
         * Expose websocket endpoints using Jetty.
         * 
         * Category: websocket
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-websocket
         * 
         * Syntax: <code>websocket:host:port/resourceUri</code>
         * 
         * Path parameter: host
         * The hostname. The default value is 0.0.0.0. Setting this option on
         * the component will use the component configured value as default.
         * Default value: 0.0.0.0
         * 
         * Path parameter: port
         * The port number. The default value is 9292. Setting this option on
         * the component will use the component configured value as default.
         * Default value: 9292
         * 
         * Path parameter: resourceUri (required)
         * Name of the websocket channel to use
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port/resourceUri
         * @return the dsl builder
         */
        default WebsocketEndpointBuilder websocket(
                String componentName,
                String path) {
            return WebsocketEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Jetty Websocket component.
     */
    public static class WebsocketHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WebsocketHeaderNameBuilder INSTANCE = new WebsocketHeaderNameBuilder();

        /**
         * Producer: Sends the message to all clients which are currently
         * connected. You can use the sendToAll option on the endpoint instead
         * of using this header. Consumer: Connection key identifying an
         * individual client connection. You can save this and specify it again
         * when routing to a producer endpoing in order to direct messages to a
         * specific connected client.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code websocket.connectionKey}.
         */
        public String websocketConnectionkey() {
            return "websocket.connectionKey";
        }

        /**
         * Sends the message to all clients which are currently connected. You
         * can use the sendToAll option on the endpoint instead of using this
         * header.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code websocket.sendToAll}.
         */
        public String websocketSendtoall() {
            return "websocket.sendToAll";
        }

        /**
         * Remote address of the websocket session.
         * 
         * The option is a: {@code java.net.InetSocketAddress} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code websocket.remoteAddress}.
         */
        public String websocketRemoteaddress() {
            return "websocket.remoteAddress";
        }

        /**
         * If a specific subprotocol was negotiated, it will be specfied in this
         * header. Note that if you specify the any subprotocol to be supported,
         * and a client requests a specific subprotocol, the connection will be
         * accepted without a specific subprotocol being used. You need to
         * specifically support a given protocol by name if you want it returned
         * to the client and to show up in the message header.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code websocket.subprotocol}.
         */
        public String websocketSubprotocol() {
            return "websocket.subprotocol";
        }

        /**
         * If you specify a wildcard URI path for an endpoint, and a websocket
         * client connects to that websocket endpoing, the relative path that
         * the client specified will be provided in this header. For example, if
         * you specified websocket://0.0.0.0:80/api/ as your endpoint URI, and a
         * client connects to the server at
         * ws://host.com/api/specialized/apipath then specialized/apipath is
         * provided in the relative path header of all messages from that
         * client.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code websocket.relativePath}.
         */
        public String websocketRelativepath() {
            return "websocket.relativePath";
        }
    }
    static WebsocketEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class WebsocketEndpointBuilderImpl extends AbstractEndpointBuilder implements WebsocketEndpointBuilder, AdvancedWebsocketEndpointBuilder {
            public WebsocketEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WebsocketEndpointBuilderImpl(path);
    }
}