/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch5;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.elasticsearch5.ElasticsearchComponent;
import org.apache.camel.component.elasticsearch5.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch5.ElasticsearchProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.elasticsearch.client.transport.TransportClient;

@UriEndpoint(firstVersion="2.19.0", scheme="elasticsearch5", title="Elasticsearch5", syntax="elasticsearch5:clusterName", producerOnly=true, label="monitoring,search")
public class ElasticsearchEndpoint
extends DefaultEndpoint {
    @UriParam
    protected final ElasticsearchConfiguration configuration;
    private TransportClient client;

    public ElasticsearchEndpoint(String uri, ElasticsearchComponent component, ElasticsearchConfiguration config, TransportClient client) throws Exception {
        super(uri, (Component)component);
        this.configuration = config;
        this.client = client;
    }

    public Producer createProducer() throws Exception {
        return new ElasticsearchProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from an ElasticsearchEndpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    public TransportClient getClient() {
        return this.client;
    }
}

