/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch.rest.client;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.elasticsearch.rest.client.ElasticsearchRestClientEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.elasticsearch.client.RestClient;

@Component(value="elasticsearch-rest-client")
public class ElasticsearchRestClientComponent
extends DefaultComponent {
    @Metadata(label="advanced", autowired=true)
    RestClient restClient;
    @Metadata
    String hostAddressesList;
    @Metadata(defaultValue="30000")
    private int connectionTimeout = 30000;
    @Metadata(defaultValue="30000")
    private int socketTimeout = 30000;
    @Metadata(label="security", secret=true)
    private String user;
    @Metadata(label="security", secret=true)
    private String password;
    @Metadata(label="security", supportFileReference=true)
    private String certificatePath;
    @Metadata(label="advanced")
    private boolean enableSniffer;
    @Metadata(label="advanced", defaultValue="60000")
    private int snifferInterval = 60000;
    @Metadata(label="advanced", defaultValue="60000")
    private int sniffAfterFailureDelay = 60000;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("Cluster Name must be specified.");
        }
        ElasticsearchRestClientEndpoint endpoint = new ElasticsearchRestClientEndpoint(uri, this);
        endpoint.setRestClient(this.restClient);
        endpoint.setHostAddressesList(this.hostAddressesList);
        endpoint.setConnectionTimeout(this.connectionTimeout);
        endpoint.setSocketTimeout(this.socketTimeout);
        endpoint.setUser(this.user);
        endpoint.setPassword(this.password);
        endpoint.setCertificatePath(this.certificatePath);
        endpoint.setEnableSniffer(this.enableSniffer);
        endpoint.setSnifferInterval(this.snifferInterval);
        endpoint.setSniffAfterFailureDelay(this.sniffAfterFailureDelay);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public String getHostAddressesList() {
        return this.hostAddressesList;
    }

    public void setHostAddressesList(String hostAddressesList) {
        this.hostAddressesList = hostAddressesList;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public boolean isEnableSniffer() {
        return this.enableSniffer;
    }

    public void setEnableSniffer(boolean enableSniffer) {
        this.enableSniffer = enableSniffer;
    }

    public int getSnifferInterval() {
        return this.snifferInterval;
    }

    public void setSnifferInterval(int snifferInterval) {
        this.snifferInterval = snifferInterval;
    }

    public int getSniffAfterFailureDelay() {
        return this.sniffAfterFailureDelay;
    }

    public void setSniffAfterFailureDelay(int sniffAfterFailureDelay) {
        this.sniffAfterFailureDelay = sniffAfterFailureDelay;
    }
}

