/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import org.apache.camel.spi.Metadata;

public interface EhcacheConstants {
    @Metadata(description="The operation to be performed on the cache, valid options are:\n\n* CLEAR\n* PUT\n* PUT_ALL\n* PUT_IF_ABSENT\n* GET\n* GET_ALL\n* REMOVE\n* REMOVE_ALL\n* REPLACE", javaType="String")
    public static final String ACTION = "CamelEhcacheAction";
    @Metadata(description="Set to true if the action has a result", javaType="Boolean")
    public static final String ACTION_HAS_RESULT = "CamelEhcacheActionHasResult";
    @Metadata(description="Set to true if the action was successful", javaType="Boolean")
    public static final String ACTION_SUCCEEDED = "CamelEhcacheActionSucceeded";
    @Metadata(description="The cache key used for an action", javaType="Object")
    public static final String KEY = "CamelEhcacheKey";
    @Metadata(description="A list of keys, used in\n\n* PUT_ALL\n* GET_ALL\n* REMOVE_ALL\n", javaType="Set<Object>")
    public static final String KEYS = "CamelEhcacheKeys";
    @Metadata(description="The value to put in the cache or the result of an operation", javaType="Object")
    public static final String VALUE = "CamelEhcacheValue";
    @Metadata(description="The old value associated to a key for actions like PUT_IF_ABSENT or the\nObject used for comparison for actions like REPLACE", javaType="Object")
    public static final String OLD_VALUE = "CamelEhcacheOldValue";
    @Metadata(description="The type of event received", javaType="EventType")
    public static final String EVENT_TYPE = "CamelEhcacheEventType";
    public static final String ACTION_CLEAR = "CLEAR";
    public static final String ACTION_PUT = "PUT";
    public static final String ACTION_PUT_ALL = "PUT_ALL";
    public static final String ACTION_PUT_IF_ABSENT = "PUT_IF_ABSENT";
    public static final String ACTION_GET = "GET";
    public static final String ACTION_GET_ALL = "GET_ALL";
    public static final String ACTION_REMOVE = "REMOVE";
    public static final String ACTION_REMOVE_ALL = "REMOVE_ALL";
    public static final String ACTION_REPLACE = "REPLACE";
}

