/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.ShutdownableService;
import org.apache.camel.component.ehcache.EhcacheComponent;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.component.ehcache.EhcacheConstants;
import org.apache.camel.component.ehcache.EhcacheConsumer;
import org.apache.camel.component.ehcache.EhcacheManager;
import org.apache.camel.component.ehcache.EhcacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;

@UriEndpoint(firstVersion="2.18.0", scheme="ehcache", title="Ehcache", syntax="ehcache:cacheName", category={Category.CACHE, Category.CLUSTERING}, headersClass=EhcacheConstants.class)
public class EhcacheEndpoint
extends DefaultEndpoint {
    @UriPath(description="the cache name")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final EhcacheConfiguration configuration;
    private EhcacheManager cacheManager;

    EhcacheEndpoint(String uri, EhcacheComponent component, String cacheName, EhcacheConfiguration configuration) {
        super(uri, (Component)component);
        this.cacheName = cacheName;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new EhcacheProducer(this, this.cacheName, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        EhcacheConsumer consumer = new EhcacheConsumer(this, this.cacheName, this.configuration, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public EhcacheComponent getComponent() {
        return (EhcacheComponent)super.getComponent();
    }

    protected void doStart() throws Exception {
        if (this.cacheManager == null) {
            this.cacheManager = this.getComponent().createCacheManager(this.configuration);
        }
        ServiceHelper.startService((Service)this.cacheManager);
        this.cacheManager.incRef();
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.cacheManager);
        if (this.cacheManager != null) {
            this.cacheManager.decRef();
        }
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((ShutdownableService)this.cacheManager);
    }

    EhcacheManager getManager() {
        return this.cacheManager;
    }

    EhcacheConfiguration getConfiguration() {
        return this.configuration;
    }
}

