/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReferenceCount;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.UserManagedCache;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheManager
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheManager.class);
    private final EhcacheConfiguration configuration;
    private final CacheManager cacheManager;
    private final ConcurrentMap<String, UserManagedCache<?, ?>> userCaches;
    private final ReferenceCount refCount;

    public EhcacheManager(CacheManager cacheManager, boolean managed, EhcacheConfiguration configuration) {
        this.cacheManager = (CacheManager)ObjectHelper.notNull((Object)cacheManager, (String)"cacheManager");
        this.userCaches = new ConcurrentHashMap();
        this.configuration = configuration;
        this.refCount = ReferenceCount.on((Runnable)(managed ? () -> ((CacheManager)cacheManager).init() : () -> {}), (Runnable)(managed ? () -> ((CacheManager)cacheManager).close() : () -> {}));
    }

    public synchronized void start() throws Exception {
        this.refCount.retain();
    }

    public synchronized void stop() throws Exception {
        this.refCount.release();
        this.userCaches.values().forEach(UserManagedCache::close);
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) throws Exception {
        Cache cache = this.cacheManager.getCache(name, keyType, valueType);
        if (cache == null && this.configuration != null && this.configuration.isCreateCacheIfNotExist()) {
            CacheConfiguration cacheConfiguration = null;
            if (this.configuration.hasConfiguration(name)) {
                LOGGER.debug("Using custom cache configuration for cache {}", (Object)name);
                cacheConfiguration = (CacheConfiguration)CacheConfiguration.class.cast(this.configuration.getConfigurations().get(name));
            } else if (this.configuration.hasConfiguration()) {
                LOGGER.debug("Using global cache configuration for cache {}", (Object)name);
                cacheConfiguration = (CacheConfiguration)CacheConfiguration.class.cast(this.configuration.getConfiguration());
            }
            if (cacheConfiguration != null) {
                cache = this.cacheManager.createCache(name, cacheConfiguration);
            } else {
                LOGGER.debug("Using a UserManagedCache for cache {} as no configuration has been found", (Object)name);
                cache = (Cache)Cache.class.cast(this.userCaches.computeIfAbsent(name, key -> UserManagedCacheBuilder.newUserManagedCacheBuilder((Class)keyType, (Class)valueType).build(true)));
            }
        }
        if (cache == null) {
            throw new RuntimeCamelException("Unable to retrieve the cache " + name + " from cache manager " + this.cacheManager);
        }
        return cache;
    }

    CacheManager getCacheManager() {
        return this.cacheManager;
    }

    ReferenceCount getReferenceCount() {
        return this.refCount;
    }
}

