/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlConfiguration;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlEndpoint;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlMessage;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlService;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.HeaderSelectorProducer;
import org.apache.camel.util.ObjectHelper;

public class DynamicRouterControlProducer
extends HeaderSelectorProducer {
    private final DynamicRouterControlService dynamicRouterControlService;
    private final DynamicRouterControlConfiguration configuration;

    public DynamicRouterControlProducer(DynamicRouterControlEndpoint endpoint, DynamicRouterControlService dynamicRouterControlService, DynamicRouterControlConfiguration configuration) {
        super((Endpoint)endpoint, "CamelDynamicRouterControlAction", configuration::getControlActionOrDefault);
        this.dynamicRouterControlService = dynamicRouterControlService;
        this.configuration = configuration;
    }

    static String subscribeFromMessage(DynamicRouterControlService dynamicRouterControlService, Message message, boolean update) {
        DynamicRouterControlMessage messageBody = (DynamicRouterControlMessage)message.getBody(DynamicRouterControlMessage.class);
        String subscriptionId = messageBody.getSubscriptionId();
        String subscribeChannel = messageBody.getSubscribeChannel();
        String destinationUri = messageBody.getDestinationUri();
        String priority = String.valueOf(messageBody.getPriority());
        String predicate = messageBody.getPredicate();
        String predicateBean = messageBody.getPredicateBean();
        String expressionLanguage = messageBody.getExpressionLanguage();
        if (ObjectHelper.isNotEmpty((String)predicateBean)) {
            return dynamicRouterControlService.subscribeWithPredicateBean(subscribeChannel, subscriptionId, destinationUri, Integer.parseInt(priority), predicateBean, update);
        }
        if (ObjectHelper.isNotEmpty((String)predicate) && ObjectHelper.isNotEmpty((String)expressionLanguage)) {
            return dynamicRouterControlService.subscribeWithPredicateExpression(subscribeChannel, subscriptionId, destinationUri, Integer.parseInt(priority), predicate, expressionLanguage, update);
        }
        throw new IllegalStateException("Predicate bean could not be found");
    }

    static String subscribeFromHeaders(DynamicRouterControlService dynamicRouterControlService, Message message, boolean update) {
        Map headers = message.getHeaders();
        String subscriptionId = (String)headers.get("CamelDynamicRouterSubscriptionId");
        String subscribeChannel = (String)headers.get("CamelDynamicRouterSubscribeChannel");
        String destinationUri = (String)headers.get("CamelDynamicRouterDestinationUri");
        String priority = String.valueOf(headers.get("CamelDynamicRouterPriority"));
        String predicate = (String)headers.get("CamelDynamicRouterPredicate");
        String predicateBean = (String)headers.get("CamelDynamicRouterPredicateBean");
        String expressionLanguage = Optional.ofNullable((String)headers.get("CamelDynamicRouterExpressionLanguage")).orElse("simple");
        if (ObjectHelper.isNotEmpty((String)predicateBean)) {
            return dynamicRouterControlService.subscribeWithPredicateBean(subscribeChannel, subscriptionId, destinationUri, Integer.parseInt(priority), predicateBean, update);
        }
        if (ObjectHelper.isNotEmpty((String)predicate) && ObjectHelper.isNotEmpty((String)expressionLanguage)) {
            return dynamicRouterControlService.subscribeWithPredicateExpression(subscribeChannel, subscriptionId, destinationUri, Integer.parseInt(priority), predicate, expressionLanguage, update);
        }
        return dynamicRouterControlService.subscribeWithPredicateInstance(subscribeChannel, subscriptionId, destinationUri, Integer.parseInt(priority), message.getBody(), update);
    }

    @InvokeOnHeader(value="subscribe")
    public void performSubscribe(Message message, AsyncCallback callback) {
        String filterId = message.getBody() instanceof DynamicRouterControlMessage ? DynamicRouterControlProducer.subscribeFromMessage(this.dynamicRouterControlService, message, false) : DynamicRouterControlProducer.subscribeFromHeaders(this.dynamicRouterControlService, message, false);
        message.setBody((Object)filterId);
        callback.done(false);
    }

    @InvokeOnHeader(value="unsubscribe")
    public void performUnsubscribe(Message message, AsyncCallback callback) {
        Map headers = message.getHeaders();
        String subscriptionId = headers.getOrDefault("CamelDynamicRouterSubscriptionId", this.configuration.getSubscriptionId());
        String subscribeChannel = headers.getOrDefault("CamelDynamicRouterSubscribeChannel", this.configuration.getSubscribeChannel());
        boolean result = this.dynamicRouterControlService.removeSubscription(subscribeChannel, subscriptionId);
        message.setBody((Object)result, Boolean.TYPE);
        callback.done(false);
    }

    @InvokeOnHeader(value="update")
    public void performUpdate(Message message, AsyncCallback callback) {
        String filterId = message.getBody() instanceof DynamicRouterControlMessage ? DynamicRouterControlProducer.subscribeFromMessage(this.dynamicRouterControlService, message, true) : DynamicRouterControlProducer.subscribeFromHeaders(this.dynamicRouterControlService, message, true);
        message.setBody((Object)filterId);
        callback.done(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InvokeOnHeader(value="list")
    public void performList(Exchange exchange, AsyncCallback callback) {
        Message message = exchange.getMessage();
        Map headers = message.getHeaders();
        String subscribeChannel = headers.getOrDefault("CamelDynamicRouterSubscribeChannel", this.configuration.getSubscribeChannel());
        try {
            String filters = this.dynamicRouterControlService.getSubscriptionsForChannel(subscribeChannel);
            message.setBody((Object)filters, String.class);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InvokeOnHeader(value="statistics")
    public void performStats(Exchange exchange, AsyncCallback callback) {
        Message message = exchange.getMessage();
        Map headers = message.getHeaders();
        String subscribeChannel = headers.getOrDefault("CamelDynamicRouterSubscribeChannel", this.configuration.getSubscribeChannel());
        try {
            String stats = this.dynamicRouterControlService.getStatisticsForChannel(subscribeChannel);
            message.setBody((Object)stats, String.class);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(false);
        }
    }

    public static class DynamicRouterControlProducerFactory {
        public DynamicRouterControlProducer getInstance(DynamicRouterControlEndpoint endpoint, DynamicRouterControlService dynamicRouterControlService, DynamicRouterControlConfiguration configuration) {
            return new DynamicRouterControlProducer(endpoint, dynamicRouterControlService, configuration);
        }
    }
}

