/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.filter;

import java.util.concurrent.atomic.AtomicLong;

public class PrioritizedFilterStatistics {
    private final String filterId;
    private final AtomicLong count;
    private final AtomicLong first;
    private final AtomicLong last;

    public PrioritizedFilterStatistics(String filterId) {
        this.filterId = filterId;
        this.count = new AtomicLong(0L);
        this.first = new AtomicLong(0L);
        this.last = new AtomicLong(0L);
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void incrementCount() {
        long now = System.currentTimeMillis();
        if (this.count.incrementAndGet() == 1L) {
            this.first.compareAndSet(0L, now);
        }
        this.last.updateAndGet(v -> Math.max(v, now));
    }

    public long getCount() {
        return this.count.get();
    }

    public long getFirst() {
        return this.first.get();
    }

    public long getLast() {
        return this.last.get();
    }

    public String toString() {
        return String.format("PrioritizedFilterStatistics [id: %s, count: %d, first: %d, last: %d]", this.getFilterId(), this.getCount(), this.getFirst(), this.getLast());
    }
}

