/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.dynamicrouter.DynamicRouterComponent;
import org.apache.camel.component.dynamicrouter.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.DynamicRouterEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRouterProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterProducer.class);
    private final DynamicRouterEndpoint endpoint;
    private final DynamicRouterConfiguration configuration;

    public DynamicRouterProducer(DynamicRouterEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
        LOG.debug("Created producer for endpoint '{}', channel '{}'", (Object)endpoint.getEndpointUri(), (Object)this.configuration.getChannel());
    }

    private DynamicRouterComponent getComponent() {
        return this.endpoint.getDynamicRouterComponent();
    }

    public void process(Exchange exchange) throws Exception {
        this.getComponent().getRoutingProcessor(this.configuration.getChannel()).process(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.configuration.isSynchronous()) {
            try {
                this.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            finally {
                callback.done(true);
            }
            return true;
        }
        return this.getComponent().getRoutingProcessor(this.configuration.getChannel()).process(exchange, callback);
    }

    public static class DynamicRouterProducerFactory {
        public DynamicRouterProducer getInstance(DynamicRouterEndpoint endpoint) {
            return new DynamicRouterProducer(endpoint);
        }
    }
}

