/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import java.util.Comparator;
import org.apache.camel.CamelContext;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.FilterProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrioritizedFilterProcessor
extends FilterProcessor
implements Comparable<PrioritizedFilterProcessor> {
    public static final Comparator<PrioritizedFilterProcessor> COMPARATOR = Comparator.comparingInt(PrioritizedFilterProcessor::getPriority).thenComparing(FilterProcessor::getId);
    private static final Logger LOG = LoggerFactory.getLogger(PrioritizedFilterProcessor.class);
    private final int priority;

    public PrioritizedFilterProcessor(String id, int priority, CamelContext context, Predicate predicate, Processor processor) {
        super(context, predicate, processor);
        this.setId(id);
        this.priority = priority;
        LOG.debug("Created Dynamic Router Prioritized Filter Processor");
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(PrioritizedFilterProcessor other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return String.format("PrioritizedFilterProcessor [id: %s, priority: %s, predicate: %s]", this.getId(), this.getPriority(), this.getPredicate());
    }

    public static class PrioritizedFilterProcessorFactory {
        public PrioritizedFilterProcessor getInstance(String id, int priority, CamelContext context, Predicate predicate, Processor processor) {
            return new PrioritizedFilterProcessor(id, priority, context, predicate, processor);
        }
    }
}

