/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.core;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.SearchOptions;
import com.dropbox.core.v2.files.SearchV2Result;
import com.dropbox.core.v2.files.WriteMode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.dto.DropboxDelResult;
import org.apache.camel.component.dropbox.dto.DropboxFileDownloadResult;
import org.apache.camel.component.dropbox.dto.DropboxFileUploadResult;
import org.apache.camel.component.dropbox.dto.DropboxMoveResult;
import org.apache.camel.component.dropbox.dto.DropboxSearchResult;
import org.apache.camel.component.dropbox.util.DropboxException;
import org.apache.camel.component.dropbox.util.DropboxResultCode;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DropboxAPIFacade {
    private static final Logger LOG = LoggerFactory.getLogger(DropboxAPIFacade.class);
    private final DbxClientV2 client;
    private final Exchange exchange;

    public DropboxAPIFacade(DbxClientV2 client, Exchange exchange) {
        this.client = client;
        this.exchange = exchange;
    }

    public DropboxFileUploadResult put(String localPath, String remotePath, DropboxUploadMode mode) throws DropboxException {
        String dropboxPath = remotePath == null ? localPath : remotePath;
        boolean isPresent = true;
        try {
            this.client.files().getMetadata(dropboxPath);
        }
        catch (DbxException e) {
            isPresent = false;
        }
        if (localPath != null) {
            return this.putFile(localPath, mode, dropboxPath, isPresent);
        }
        return this.putBody(this.exchange, mode, dropboxPath, isPresent);
    }

    private DropboxFileUploadResult putFile(String localPath, DropboxUploadMode mode, String dropboxPath, boolean isPresent) throws DropboxException {
        File fileLocalPath = new File(localPath);
        if (fileLocalPath.isFile()) {
            DropboxFileUploadResult result;
            if (isPresent && !DropboxUploadMode.force.equals((Object)mode)) {
                throw new DropboxException((String)dropboxPath + " exists on dropbox. Use force upload mode to override");
            }
            if (!isPresent && ((String)dropboxPath).endsWith("/")) {
                dropboxPath = (String)dropboxPath + fileLocalPath.getName();
            }
            LOG.debug("Uploading: {},{}", (Object)fileLocalPath, dropboxPath);
            try {
                FileMetadata uploadedFile = this.putSingleFile(fileLocalPath, (String)dropboxPath, mode);
                result = uploadedFile == null ? new DropboxFileUploadResult((String)dropboxPath, DropboxResultCode.KO) : new DropboxFileUploadResult((String)dropboxPath, DropboxResultCode.OK);
            }
            catch (Exception ex) {
                result = new DropboxFileUploadResult((String)dropboxPath, DropboxResultCode.KO);
            }
            return result;
        }
        if (fileLocalPath.isDirectory()) {
            LOG.debug("Uploading a dir...");
            if (isPresent && !DropboxUploadMode.force.equals((Object)mode)) {
                throw new DropboxException((String)dropboxPath + " exists on dropbox and is not a folder!");
            }
            if (!((String)dropboxPath).endsWith("/")) {
                dropboxPath = (String)dropboxPath + "/";
            }
            Object oldDropboxPath = dropboxPath;
            Collection listFiles = FileUtils.listFiles((File)fileLocalPath, null, (boolean)true);
            if (listFiles.isEmpty()) {
                throw new DropboxException(localPath + " does not contain any files");
            }
            HashMap<String, DropboxResultCode> resultMap = new HashMap<String, DropboxResultCode>(listFiles.size());
            for (File file : listFiles) {
                String absPath = file.getAbsolutePath();
                int indexRemainingPath = localPath.length();
                if (!localPath.endsWith("/")) {
                    ++indexRemainingPath;
                }
                String remainingPath = absPath.substring(indexRemainingPath);
                dropboxPath = (String)dropboxPath + remainingPath;
                try {
                    LOG.debug("Uploading: {},{}", (Object)fileLocalPath, dropboxPath);
                    FileMetadata uploadedFile = this.putSingleFile(file, (String)dropboxPath, mode);
                    if (uploadedFile == null) {
                        resultMap.put((String)dropboxPath, DropboxResultCode.KO);
                    } else {
                        resultMap.put((String)dropboxPath, DropboxResultCode.OK);
                    }
                }
                catch (Exception ex) {
                    resultMap.put((String)dropboxPath, DropboxResultCode.KO);
                }
                dropboxPath = oldDropboxPath;
            }
            return new DropboxFileUploadResult(resultMap);
        }
        return null;
    }

    private DropboxFileUploadResult putBody(Exchange exchange, DropboxUploadMode mode, String dropboxPath, boolean isPresent) {
        DropboxFileUploadResult result;
        String name = (String)exchange.getIn().getHeader("CamelDropboxPutFileName", String.class);
        if (name == null) {
            name = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        }
        if (name == null) {
            name = exchange.getIn().getMessageId();
        }
        if (!isPresent && ((String)dropboxPath).endsWith("/")) {
            dropboxPath = (String)dropboxPath + name;
        }
        LOG.debug("Uploading message body: {}", dropboxPath);
        try {
            FileMetadata uploadedFile = this.putSingleBody(exchange, (String)dropboxPath, mode);
            result = uploadedFile == null ? new DropboxFileUploadResult((String)dropboxPath, DropboxResultCode.KO) : new DropboxFileUploadResult((String)dropboxPath, DropboxResultCode.OK);
        }
        catch (Exception ex) {
            result = new DropboxFileUploadResult((String)dropboxPath, DropboxResultCode.KO);
        }
        return result;
    }

    private FileMetadata putSingleFile(File inputFile, String dropboxPath, DropboxUploadMode mode) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            WriteMode uploadMode = mode == DropboxUploadMode.force ? WriteMode.OVERWRITE : WriteMode.ADD;
            FileMetadata fileMetadata = (FileMetadata)this.client.files().uploadBuilder(dropboxPath).withMode(uploadMode).uploadAndFinish((InputStream)inputStream, inputFile.length());
            return fileMetadata;
        }
    }

    private FileMetadata putSingleBody(Exchange exchange, String dropboxPath, DropboxUploadMode mode) throws Exception {
        byte[] data = (byte[])exchange.getIn().getMandatoryBody(byte[].class);
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            WriteMode uploadMode = mode == DropboxUploadMode.force ? WriteMode.OVERWRITE : WriteMode.ADD;
            FileMetadata fileMetadata = (FileMetadata)this.client.files().uploadBuilder(dropboxPath).withMode(uploadMode).uploadAndFinish((InputStream)is, (long)data.length);
            return fileMetadata;
        }
    }

    public DropboxSearchResult search(String remotePath, String query) throws DropboxException {
        if (query == null) {
            LOG.debug("Search no query");
        } else {
            LOG.debug("Search by query: {}", (Object)query);
        }
        try {
            SearchV2Result listing = this.client.files().searchV2Builder(query).withOptions(SearchOptions.newBuilder().withPath(remotePath).build()).start();
            return new DropboxSearchResult(listing.getMatches());
        }
        catch (DbxException e) {
            throw new DropboxException(String.format("%s does not exist or cannot obtain metadata", remotePath), e);
        }
    }

    public DropboxDelResult del(String remotePath) throws DropboxException {
        try {
            this.client.files().deleteV2(remotePath);
        }
        catch (DbxException e) {
            throw new DropboxException(String.format("%s does not exist or cannot obtain metadata", remotePath), e);
        }
        return new DropboxDelResult(remotePath);
    }

    public DropboxMoveResult move(String remotePath, String newRemotePath) throws DropboxException {
        try {
            this.client.files().moveV2(remotePath, newRemotePath);
            return new DropboxMoveResult(remotePath, newRemotePath);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or cannot obtain metadata", e);
        }
    }

    public DropboxFileDownloadResult get(String remotePath) throws DropboxException {
        return new DropboxFileDownloadResult(this.downloadFilesInFolder(remotePath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> downloadFilesInFolder(String path) throws DropboxException {
        try {
            ListFolderResult folderResult = this.client.files().listFolder(path.equals("/") ? "" : path);
            LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
            Iterator iterator = folderResult.getEntries().iterator();
            while (iterator.hasNext()) {
                Metadata entry = (Metadata)iterator.next();
                Map.Entry<String, Object> singleFile = this.downloadSingleFile(entry.getPathDisplay());
                if (singleFile == null) continue;
                returnMap.put(entry.getPathDisplay(), singleFile.getValue());
            }
            return returnMap;
        }
        catch (ListFolderErrorException e) {
            try (DbxDownloader listing = this.client.files().download(path);){
                if (listing == null) {
                    Map<String, Object> map = Map.of();
                    return map;
                }
                LOG.debug("downloading a single file...");
                Map.Entry<String, Object> entry = this.downloadSingleFile(path);
                if (entry == null) {
                    Map<String, Object> map = Map.of();
                    return map;
                }
                Map<String, Object> map = Map.of(entry.getKey(), entry.getValue());
                return map;
            }
            catch (DbxException dbxException) {
                throw new DropboxException(dbxException);
            }
        }
        catch (DbxException e) {
            throw new DropboxException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map.Entry<String, Object> downloadSingleFile(String path) throws DropboxException {
        try (OutputStreamBuilder target = OutputStreamBuilder.withExchange((Exchange)this.exchange);){
            AbstractMap.SimpleEntry<String, Object> simpleEntry;
            block19: {
                DbxDownloader downloadedFile;
                block17: {
                    Map.Entry<String, Object> entry;
                    block18: {
                        downloadedFile = this.client.files().download(path);
                        try {
                            if (downloadedFile != null) break block17;
                            entry = null;
                            if (downloadedFile == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (downloadedFile != null) {
                                try {
                                    downloadedFile.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        downloadedFile.close();
                    }
                    return entry;
                }
                downloadedFile.download((OutputStream)target);
                LOG.debug("downloaded path={}", (Object)path);
                simpleEntry = new AbstractMap.SimpleEntry<String, Object>(path, target.build());
                if (downloadedFile == null) break block19;
                downloadedFile.close();
            }
            return simpleEntry;
        }
        catch (DbxException e) {
            throw new DropboxException(path + " does not exist or cannot obtain metadata", e);
        }
        catch (IOException e) {
            throw new DropboxException(path + " cannot obtain a stream", e);
        }
    }
}

