/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.producer;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.command.AsyncDockerCmd;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.WaitResponse;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.component.docker.DockerOperation;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDockerProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDockerProducer.class);
    private DockerConfiguration configuration;
    private DockerComponent component;

    public AsyncDockerProducer(DockerEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Message message = exchange.getIn();
            DockerClient client = DockerClientFactory.getDockerClient(this.component, this.configuration, message);
            DockerOperation operation = this.configuration.getOperation();
            switch (operation) {
                case BUILD_IMAGE: {
                    this.runAsyncImageBuild(exchange, message, client);
                    break;
                }
                case PULL_IMAGE: {
                    this.runAsyncPull(message, client, exchange);
                    break;
                }
                case PUSH_IMAGE: {
                    this.runAsyncPush(exchange, message, client);
                    break;
                }
                case ATTACH_CONTAINER: {
                    this.runAsyncAttachContainer(exchange, message, client);
                    break;
                }
                case LOG_CONTAINER: {
                    this.runAsyncLogContainer(exchange, message, client);
                    break;
                }
                case WAIT_CONTAINER: {
                    this.runAsyncWaitContainer(exchange, message, client);
                    break;
                }
                case EXEC_START: {
                    this.runAsyncExecStart(exchange, message, client);
                    break;
                }
                default: {
                    throw new DockerException("Invalid operation: " + operation);
                }
            }
        }
        catch (InterruptedException | DockerException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        callback.done(false);
        return false;
    }

    private void runAsyncImageBuild(final Exchange exchange, Message message, DockerClient client) throws DockerException, InterruptedException {
        try (BuildImageCmd cmd = this.executeBuildImageRequest(client, message);){
            BuildImageResultCallback item = (BuildImageResultCallback)cmd.exec((ResultCallback)new BuildImageResultCallback(){

                public void onNext(BuildResponseItem item) {
                    super.onNext(item);
                    LOG.trace("build image callback {}", (Object)item);
                    exchange.getIn().setBody((Object)item.getImageId());
                }
            });
            this.setResponse(exchange, (ResultCallbackTemplate)item);
        }
    }

    private void runAsyncWithFrameResponse(Exchange exchange, AsyncDockerCmd<?, Frame> cmd) throws InterruptedException {
        ResultCallback.Adapter item = (ResultCallback.Adapter)cmd.exec((ResultCallback)new ResultCallback.Adapter<Frame>(){

            public void onNext(Frame item) {
                LOG.trace("running framed callback {}", (Object)item);
                super.onNext((Object)item);
            }
        });
        this.setResponse(exchange, (ResultCallbackTemplate)item);
    }

    private void runAsyncExecStart(Exchange exchange, Message message, DockerClient client) throws InterruptedException {
        try (ExecStartCmd cmd = this.executeExecStartRequest(client, message);){
            this.runAsyncWithFrameResponse(exchange, (AsyncDockerCmd<?, Frame>)cmd);
        }
    }

    private void runAsyncWaitContainer(Exchange exchange, Message message, DockerClient client) throws InterruptedException {
        try (WaitContainerCmd cmd = this.executeWaitContainerRequest(client, message);){
            WaitContainerResultCallback item = (WaitContainerResultCallback)cmd.exec((ResultCallback)new WaitContainerResultCallback(){

                public void onNext(WaitResponse item) {
                    super.onNext(item);
                    LOG.trace("wait container callback {}", (Object)item);
                }
            });
            this.setResponse(exchange, (ResultCallbackTemplate)item);
        }
    }

    private void setResponse(Exchange exchange, ResultCallbackTemplate item) throws InterruptedException {
        if (item != null) {
            exchange.getIn().setBody((Object)item);
            item.awaitCompletion();
        }
    }

    private void runAsyncLogContainer(Exchange exchange, Message message, DockerClient client) throws InterruptedException {
        try (LogContainerCmd cmd = this.executeLogContainerRequest(client, message);){
            this.runAsyncWithFrameResponse(exchange, (AsyncDockerCmd<?, Frame>)cmd);
        }
    }

    private void runAsyncAttachContainer(Exchange exchange, Message message, DockerClient client) throws InterruptedException {
        try (AttachContainerCmd cmd = this.executeAttachContainerRequest(client, message);){
            this.runAsyncWithFrameResponse(exchange, (AsyncDockerCmd<?, Frame>)cmd);
        }
    }

    private void runAsyncPush(Exchange exchange, Message message, DockerClient client) throws InterruptedException {
        try (PushImageCmd cmd = this.executePushImageRequest(client, message);){
            ResultCallback.Adapter item = (ResultCallback.Adapter)cmd.exec((ResultCallback)new ResultCallback.Adapter<PushResponseItem>(){

                public void onNext(PushResponseItem item) {
                    super.onNext((Object)item);
                    LOG.trace("push image callback {}", (Object)item);
                }
            });
            this.setResponse(exchange, (ResultCallbackTemplate)item);
        }
    }

    private void runAsyncPull(Message message, DockerClient client, Exchange exchange) throws InterruptedException {
        try (PullImageCmd cmd = this.executePullImageRequest(client, message);){
            PullImageResultCallback item = (PullImageResultCallback)cmd.exec((ResultCallback)new PullImageResultCallback(){

                public void onNext(PullResponseItem item) {
                    super.onNext(item);
                    LOG.trace("pull image callback {}", (Object)item);
                }
            });
            this.setResponse(exchange, (ResultCallbackTemplate)item);
        }
    }

    private BuildImageCmd executeBuildImageRequest(DockerClient client, Message message) throws DockerException {
        String tag;
        Boolean remove;
        Boolean quiet;
        BuildImageCmd buildImageCmd;
        LOG.debug("Executing Docker Build Image Request");
        Object body = message.getBody();
        if (body instanceof InputStream) {
            buildImageCmd = client.buildImageCmd((InputStream)body);
        } else if (body instanceof File) {
            buildImageCmd = client.buildImageCmd((File)body);
        } else {
            throw new DockerException("Unable to location source Image");
        }
        Boolean noCache = DockerHelper.getProperty("CamelDockerNoCache", this.configuration, message, Boolean.class);
        if (noCache != null) {
            buildImageCmd.withNoCache(noCache);
        }
        if ((quiet = DockerHelper.getProperty("CamelDockerQuiet", this.configuration, message, Boolean.class)) != null) {
            buildImageCmd.withQuiet(quiet);
        }
        if ((remove = DockerHelper.getProperty("CamelDockerRemove", this.configuration, message, Boolean.class)) != null) {
            buildImageCmd.withRemove(remove);
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            buildImageCmd.withTags(Collections.singleton(tag));
        }
        return buildImageCmd;
    }

    private PullImageCmd executePullImageRequest(DockerClient client, Message message) {
        AuthConfig authConfig;
        String tag;
        LOG.debug("Executing Docker Pull Image Request");
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)repository, (String)"Repository must be specified");
        PullImageCmd pullImageCmd = client.pullImageCmd(repository);
        String registry = DockerHelper.getProperty("CamelDockerRegistry", this.configuration, message, String.class);
        if (registry != null) {
            pullImageCmd.withRegistry(registry);
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            pullImageCmd.withTag(tag);
        }
        if ((authConfig = client.authConfig()) != null) {
            pullImageCmd.withAuthConfig(authConfig);
        }
        return pullImageCmd;
    }

    private PushImageCmd executePushImageRequest(DockerClient client, Message message) {
        AuthConfig authConfig;
        LOG.debug("Executing Docker Push Image Request");
        String name = DockerHelper.getProperty("CamelDockerName", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)name, (String)"Image name must be specified");
        PushImageCmd pushImageCmd = client.pushImageCmd(name);
        String tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class);
        if (tag != null) {
            pushImageCmd.withTag(tag);
        }
        if ((authConfig = client.authConfig()) != null) {
            pushImageCmd.withAuthConfig(authConfig);
        }
        return pushImageCmd;
    }

    private AttachContainerCmd executeAttachContainerRequest(DockerClient client, Message message) {
        Boolean timestamps;
        Boolean stdOut;
        Boolean stdErr;
        Boolean logs;
        LOG.debug("Executing Docker Attach Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        AttachContainerCmd attachContainerCmd = client.attachContainerCmd(containerId);
        Boolean followStream = DockerHelper.getProperty("CamelDockerFollowStream", this.configuration, message, Boolean.class);
        if (followStream != null) {
            attachContainerCmd.withFollowStream(followStream);
        }
        if ((logs = DockerHelper.getProperty("CamelDockerLogs", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withLogs(logs);
        }
        if ((stdErr = DockerHelper.getProperty("CamelDockerStdErr", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withStdErr(stdErr);
        }
        if ((stdOut = DockerHelper.getProperty("CamelDockerStdOut", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withStdOut(stdOut);
        }
        if ((timestamps = DockerHelper.getProperty("CamelDockerTimestamps", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withTimestamps(timestamps);
        }
        return attachContainerCmd;
    }

    private LogContainerCmd executeLogContainerRequest(DockerClient client, Message message) {
        Boolean timestamps;
        Boolean tailAll;
        Integer tail;
        Boolean stdOut;
        Boolean stdErr;
        LOG.debug("Executing Docker Log Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        LogContainerCmd logContainerCmd = client.logContainerCmd(containerId);
        Boolean followStream = DockerHelper.getProperty("CamelDockerFollowStream", this.configuration, message, Boolean.class);
        if (followStream != null) {
            logContainerCmd.withFollowStream(followStream);
        }
        if ((stdErr = DockerHelper.getProperty("CamelDockerStdErr", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withStdErr(stdErr);
        }
        if ((stdOut = DockerHelper.getProperty("CamelDockerStdOut", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withStdOut(stdOut);
        }
        if ((tail = DockerHelper.getProperty("CamelDockerTail", this.configuration, message, Integer.class)) != null) {
            logContainerCmd.withTail(tail);
        }
        if ((tailAll = DockerHelper.getProperty("CamelDockerTailAll", this.configuration, message, Boolean.class)) != null && tailAll.booleanValue()) {
            logContainerCmd.withTailAll();
        }
        if ((timestamps = DockerHelper.getProperty("CamelDockerTimestamps", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withTimestamps(timestamps);
        }
        return logContainerCmd;
    }

    private WaitContainerCmd executeWaitContainerRequest(DockerClient client, Message message) {
        LOG.debug("Executing Docker Wait Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        return client.waitContainerCmd(containerId);
    }

    private ExecStartCmd executeExecStartRequest(DockerClient client, Message message) {
        Boolean tty;
        LOG.debug("Executing Docker Exec Start Request");
        String execId = DockerHelper.getProperty("CamelDockerExecId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)execId, (String)"Exec ID must be specified");
        ExecStartCmd execStartCmd = client.execStartCmd(execId);
        Boolean detach = DockerHelper.getProperty("CamelDockerDetach", this.configuration, message, Boolean.class);
        if (detach != null) {
            execStartCmd.withDetach(detach);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            execStartCmd.withTty(tty);
        }
        return execStartCmd;
    }
}

