/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.types;

import java.net.InetAddress;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.dns.types.DnsConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.xbill.DNS.Address;
import org.xbill.DNS.Message;
import org.xbill.DNS.Record;

@DeferredContextBinding
public final class DnsConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        DnsConverterLoader.addTypeConverter(registry, String.class, InetAddress.class, false, (type, exchange, value) -> DnsConverter.toString((InetAddress)value));
        DnsConverterLoader.addTypeConverter(registry, String.class, Address.class, false, (type, exchange, value) -> DnsConverter.toString((Address)value));
        DnsConverterLoader.addTypeConverter(registry, String.class, Message.class, false, (type, exchange, value) -> DnsConverter.toString((Message)value));
        DnsConverterLoader.addTypeConverter(registry, String.class, Record.class, false, (type, exchange, value) -> DnsConverter.toString((Record)value));
        DnsConverterLoader.addTypeConverter(registry, InetAddress.class, String.class, false, (type, exchange, value) -> DnsConverter.toInetAddress((String)value));
        DnsConverterLoader.addTypeConverter(registry, List.class, Record[].class, false, (type, exchange, value) -> DnsConverter.toList((Record[])value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

