/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl;

import ai.djl.modality.audio.Audio;
import ai.djl.modality.audio.AudioFactory;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;

@Converter(generateLoader=true)
public class DJLConverter {
    @Converter
    public static Image toImage(byte[] bytes) throws IOException {
        return DJLConverter.toImage(new ByteArrayInputStream(bytes));
    }

    @Converter
    public static Image toImage(File file) throws IOException {
        return DJLConverter.toImage(new FileInputStream(file));
    }

    @Converter
    public static Image toImage(Path path) throws IOException {
        return DJLConverter.toImage(Files.newInputStream(path, new OpenOption[0]));
    }

    @Converter
    public static Image toImage(InputStream inputStream) throws IOException {
        return ImageFactory.getInstance().fromInputStream(inputStream);
    }

    @Converter
    public static Image toImage(DetectedObjects.DetectedObject detectedObject, Exchange exchange) {
        if (exchange == null || exchange.getMessage() == null) {
            return null;
        }
        Rectangle rect = detectedObject.getBoundingBox().getBounds();
        Image image = (Image)exchange.getMessage().getHeader("CamelDjlInput", Image.class);
        return image.getSubImage((int)(rect.getX() * (double)image.getWidth()), (int)(rect.getY() * (double)image.getHeight()), (int)(rect.getWidth() * (double)image.getWidth()), (int)(rect.getHeight() * (double)image.getHeight()));
    }

    @Converter
    public static Image[] toImages(DetectedObjects detectedObjects, Exchange exchange) {
        return (Image[])detectedObjects.items().stream().map(obj -> DJLConverter.toImage(obj, exchange)).toArray(Image[]::new);
    }

    @Converter
    public static byte[] toBytes(Image image, Exchange exchange) throws IOException {
        if (exchange == null || exchange.getMessage() == null || exchange.getMessage().getHeader("CamelDjlFileType") == null) {
            throw new TypeConversionException((Object)image, Image.class, (Throwable)new IllegalStateException("File type must be provided via CamelDjlFileType header"));
        }
        String fileType = (String)exchange.getMessage().getHeader("CamelDjlFileType", String.class);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        image.save((OutputStream)os, fileType);
        return os.toByteArray();
    }

    @Converter
    public static Audio toAudio(byte[] bytes) throws IOException {
        return DJLConverter.toAudio(new ByteArrayInputStream(bytes));
    }

    @Converter
    public static Audio toAudio(File file) throws IOException {
        return DJLConverter.toAudio(new FileInputStream(file));
    }

    @Converter
    public static Audio toAudio(Path path) throws IOException {
        return DJLConverter.toAudio(Files.newInputStream(path, new OpenOption[0]));
    }

    @Converter
    public static Audio toAudio(InputStream inputStream) throws IOException {
        return AudioFactory.newInstance().fromInputStream(inputStream);
    }
}

