/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl;

import ai.djl.modality.audio.Audio;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.djl.DJLConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class DJLConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        DJLConverterLoader.addTypeConverter(registry, Audio.class, byte[].class, false, (type, exchange, value) -> DJLConverter.toAudio((byte[])value));
        DJLConverterLoader.addTypeConverter(registry, Audio.class, File.class, false, (type, exchange, value) -> DJLConverter.toAudio((File)value));
        DJLConverterLoader.addTypeConverter(registry, Audio.class, InputStream.class, false, (type, exchange, value) -> DJLConverter.toAudio((InputStream)value));
        DJLConverterLoader.addTypeConverter(registry, Audio.class, Path.class, false, (type, exchange, value) -> DJLConverter.toAudio((Path)value));
        DJLConverterLoader.addTypeConverter(registry, Image.class, DetectedObjects.DetectedObject.class, false, (type, exchange, value) -> DJLConverter.toImage((DetectedObjects.DetectedObject)value, exchange));
        DJLConverterLoader.addTypeConverter(registry, Image.class, byte[].class, false, (type, exchange, value) -> DJLConverter.toImage((byte[])value));
        DJLConverterLoader.addTypeConverter(registry, Image.class, File.class, false, (type, exchange, value) -> DJLConverter.toImage((File)value));
        DJLConverterLoader.addTypeConverter(registry, Image.class, InputStream.class, false, (type, exchange, value) -> DJLConverter.toImage((InputStream)value));
        DJLConverterLoader.addTypeConverter(registry, Image.class, Path.class, false, (type, exchange, value) -> DJLConverter.toImage((Path)value));
        DJLConverterLoader.addTypeConverter(registry, Image[].class, DetectedObjects.class, false, (type, exchange, value) -> DJLConverter.toImages((DetectedObjects)value, exchange));
        DJLConverterLoader.addTypeConverter(registry, byte[].class, Image.class, false, (type, exchange, value) -> DJLConverter.toBytes((Image)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

