/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.timeseries;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.inference.Predictor;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.timeseries.Forecast;
import ai.djl.timeseries.TimeSeriesData;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class ZooForecastingPredictor
extends AbstractPredictor {
    private final ZooModel<TimeSeriesData, Forecast> model;

    public ZooForecastingPredictor(String artifactId) throws ModelNotFoundException, MalformedModelException, IOException {
        Criteria criteria = Criteria.builder().optApplication(Application.TimeSeries.FORECASTING).setTypes(TimeSeriesData.class, Forecast.class).optArtifactId(artifactId).optProgress((Progress)new ProgressBar()).build();
        this.model = ModelZoo.loadModel((Criteria)criteria);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (!(exchange.getIn().getBody() instanceof TimeSeriesData)) {
            throw new RuntimeCamelException("Data type is not supported. Body should be TimeSeriesData");
        }
        TimeSeriesData input = (TimeSeriesData)exchange.getIn().getBody(TimeSeriesData.class);
        Forecast result = this.predict(exchange, input);
        exchange.getIn().setBody((Object)result);
    }

    protected Forecast predict(Exchange exchange, TimeSeriesData input) {
        Forecast forecast;
        block8: {
            exchange.getIn().setHeader("CamelDjlInput", (Object)input);
            Predictor predictor = this.model.newPredictor();
            try {
                forecast = (Forecast)predictor.predict((Object)input);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return forecast;
    }
}

