/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.nlp;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class CustomNlpPredictor<T>
extends AbstractPredictor {
    protected final String modelName;
    protected final String translatorName;

    public CustomNlpPredictor(String modelName, String translatorName) {
        this.modelName = modelName;
        this.translatorName = translatorName;
    }

    @Override
    public void process(Exchange exchange) {
        if (!(exchange.getIn().getBody() instanceof String)) {
            throw new RuntimeCamelException("Data type is not supported. Body should be String");
        }
        String input = (String)exchange.getIn().getBody(String.class);
        T result = this.predict(exchange, input);
        exchange.getIn().setBody(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T predict(Exchange exchange, String input) {
        Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
        Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
        exchange.getIn().setHeader("CamelDjlInput", (Object)input);
        try (Predictor predictor = model.newPredictor(translator);){
            Object object = predictor.predict((Object)input);
            return (T)object;
        }
        catch (TranslateException e) {
            throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
        }
    }
}

