/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.cv;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCvPredictor<T>
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(CustomCvPredictor.class);
    protected final String modelName;
    protected final String translatorName;

    public CustomCvPredictor(String modelName, String translatorName) {
        this.modelName = modelName;
        this.translatorName = translatorName;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        T result;
        Object body = exchange.getIn().getBody();
        if (body instanceof byte[]) {
            byte[] bytes = (byte[])exchange.getIn().getBody(byte[].class);
            result = this.predict(exchange, new ByteArrayInputStream(bytes));
        } else if (body instanceof File) {
            result = this.predict(exchange, (File)exchange.getIn().getBody(File.class));
        } else if (body instanceof InputStream) {
            result = this.predict(exchange, (InputStream)exchange.getIn().getBody(InputStream.class));
        } else {
            throw new RuntimeCamelException("Data type is not supported. Body should be byte[], InputStream or File");
        }
        exchange.getIn().setBody(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T predict(Exchange exchange, File input) {
        try (FileInputStream fileInputStream = new FileInputStream(input);){
            Image image = ImageFactory.getInstance().fromInputStream((InputStream)fileInputStream);
            T t = this.predict(exchange, image);
            return t;
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }

    protected T predict(Exchange exchange, InputStream input) {
        try {
            Image image = ImageFactory.getInstance().fromInputStream(input);
            return this.predict(exchange, image);
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T predict(Exchange exchange, Image image) {
        Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
        Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
        exchange.getIn().setHeader("CamelDjlInput", (Object)image);
        try (Predictor predictor = model.newPredictor(translator);){
            Object object = predictor.predict((Object)image);
            return (T)object;
        }
        catch (TranslateException e) {
            LOG.error("Could not process input or output", (Throwable)e);
            throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
        }
    }
}

