/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.repository.zoo.ModelNotFoundException;
import java.io.IOException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.apache.camel.component.djl.model.audio.CustomAudioPredictor;
import org.apache.camel.component.djl.model.audio.ZooAudioPredictor;
import org.apache.camel.component.djl.model.cv.CustomCvPredictor;
import org.apache.camel.component.djl.model.cv.CustomImageGenerationPredictor;
import org.apache.camel.component.djl.model.cv.ZooActionRecognitionPredictor;
import org.apache.camel.component.djl.model.cv.ZooImageClassificationPredictor;
import org.apache.camel.component.djl.model.cv.ZooImageEnhancementPredictor;
import org.apache.camel.component.djl.model.cv.ZooImageGenerationPredictor;
import org.apache.camel.component.djl.model.cv.ZooInstanceSegmentationPredictor;
import org.apache.camel.component.djl.model.cv.ZooObjectDetectionPredictor;
import org.apache.camel.component.djl.model.cv.ZooPoseEstimationPredictor;
import org.apache.camel.component.djl.model.cv.ZooSemanticSegmentationPredictor;
import org.apache.camel.component.djl.model.cv.ZooWordRecognitionPredictor;
import org.apache.camel.component.djl.model.nlp.CustomNlpPredictor;
import org.apache.camel.component.djl.model.nlp.CustomQuestionAnswerPredictor;
import org.apache.camel.component.djl.model.nlp.CustomWordEmbeddingPredictor;
import org.apache.camel.component.djl.model.nlp.ZooFillMaskPredictor;
import org.apache.camel.component.djl.model.nlp.ZooMachineTranslationPredictor;
import org.apache.camel.component.djl.model.nlp.ZooMultipleChoicePredictor;
import org.apache.camel.component.djl.model.nlp.ZooQuestionAnswerPredictor;
import org.apache.camel.component.djl.model.nlp.ZooSentimentAnalysisPredictor;
import org.apache.camel.component.djl.model.nlp.ZooTextClassificationPredictor;
import org.apache.camel.component.djl.model.nlp.ZooTextEmbeddingPredictor;
import org.apache.camel.component.djl.model.nlp.ZooTextGenerationPredictor;
import org.apache.camel.component.djl.model.nlp.ZooTokenClassificationPredictor;
import org.apache.camel.component.djl.model.nlp.ZooWordEmbeddingPredictor;
import org.apache.camel.component.djl.model.tabular.CustomTabularPredictor;
import org.apache.camel.component.djl.model.tabular.ZooLinearRegressionPredictor;
import org.apache.camel.component.djl.model.tabular.ZooSoftmaxRegressionPredictor;
import org.apache.camel.component.djl.model.timeseries.CustomForecastingPredictor;
import org.apache.camel.component.djl.model.timeseries.ZooForecastingPredictor;

public final class ModelPredictorProducer {
    private ModelPredictorProducer() {
    }

    public static AbstractPredictor getZooPredictor(String applicationPath, String artifactId) throws ModelNotFoundException, MalformedModelException, IOException {
        if (Application.CV.IMAGE_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new ZooImageClassificationPredictor(artifactId);
        }
        if (Application.CV.OBJECT_DETECTION.getPath().equals(applicationPath)) {
            return new ZooObjectDetectionPredictor(artifactId);
        }
        if (Application.CV.SEMANTIC_SEGMENTATION.getPath().equals(applicationPath)) {
            return new ZooSemanticSegmentationPredictor(artifactId);
        }
        if (Application.CV.INSTANCE_SEGMENTATION.getPath().equals(applicationPath)) {
            return new ZooInstanceSegmentationPredictor(artifactId);
        }
        if (Application.CV.POSE_ESTIMATION.getPath().equals(applicationPath)) {
            return new ZooPoseEstimationPredictor(artifactId);
        }
        if (Application.CV.ACTION_RECOGNITION.getPath().equals(applicationPath)) {
            return new ZooActionRecognitionPredictor(artifactId);
        }
        if (Application.CV.WORD_RECOGNITION.getPath().equals(applicationPath)) {
            return new ZooWordRecognitionPredictor(artifactId);
        }
        if (Application.CV.IMAGE_GENERATION.getPath().equals(applicationPath)) {
            return new ZooImageGenerationPredictor(artifactId);
        }
        if (Application.CV.IMAGE_ENHANCEMENT.getPath().equals(applicationPath)) {
            return new ZooImageEnhancementPredictor(artifactId);
        }
        if (Application.NLP.FILL_MASK.getPath().equals(applicationPath)) {
            return new ZooFillMaskPredictor(artifactId);
        }
        if (Application.NLP.QUESTION_ANSWER.getPath().equals(applicationPath)) {
            return new ZooQuestionAnswerPredictor(artifactId);
        }
        if (Application.NLP.TEXT_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new ZooTextClassificationPredictor(artifactId);
        }
        if (Application.NLP.SENTIMENT_ANALYSIS.getPath().equals(applicationPath)) {
            return new ZooSentimentAnalysisPredictor(artifactId);
        }
        if (Application.NLP.TOKEN_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new ZooTokenClassificationPredictor(artifactId);
        }
        if (Application.NLP.WORD_EMBEDDING.getPath().equals(applicationPath)) {
            return new ZooWordEmbeddingPredictor(artifactId);
        }
        if (Application.NLP.TEXT_GENERATION.getPath().equals(applicationPath)) {
            return new ZooTextGenerationPredictor(artifactId);
        }
        if (Application.NLP.MACHINE_TRANSLATION.getPath().equals(applicationPath)) {
            return new ZooMachineTranslationPredictor(artifactId);
        }
        if (Application.NLP.MULTIPLE_CHOICE.getPath().equals(applicationPath)) {
            return new ZooMultipleChoicePredictor(artifactId);
        }
        if (Application.NLP.TEXT_EMBEDDING.getPath().equals(applicationPath)) {
            return new ZooTextEmbeddingPredictor(artifactId);
        }
        if (Application.Tabular.LINEAR_REGRESSION.getPath().equals(applicationPath)) {
            return new ZooLinearRegressionPredictor(artifactId);
        }
        if (Application.Tabular.SOFTMAX_REGRESSION.getPath().equals(applicationPath)) {
            return new ZooSoftmaxRegressionPredictor(artifactId);
        }
        if (Application.Audio.ANY.getPath().equals(applicationPath)) {
            return new ZooAudioPredictor(artifactId);
        }
        if (Application.TimeSeries.FORECASTING.getPath().equals(applicationPath)) {
            return new ZooForecastingPredictor(artifactId);
        }
        throw new RuntimeCamelException("Application not supported: " + applicationPath);
    }

    public static AbstractPredictor getCustomPredictor(String applicationPath, String model, String translator) {
        if (applicationPath.equals(Application.CV.IMAGE_CLASSIFICATION.getPath())) {
            return new CustomCvPredictor(model, translator);
        }
        if (applicationPath.equals(Application.CV.OBJECT_DETECTION.getPath())) {
            return new CustomCvPredictor(model, translator);
        }
        if (Application.CV.SEMANTIC_SEGMENTATION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(model, translator);
        }
        if (Application.CV.INSTANCE_SEGMENTATION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(model, translator);
        }
        if (Application.CV.POSE_ESTIMATION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(model, translator);
        }
        if (Application.CV.ACTION_RECOGNITION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(model, translator);
        }
        if (Application.CV.WORD_RECOGNITION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(model, translator);
        }
        if (Application.CV.IMAGE_GENERATION.getPath().equals(applicationPath)) {
            return new CustomImageGenerationPredictor(model, translator);
        }
        if (Application.CV.IMAGE_ENHANCEMENT.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(model, translator);
        }
        if (Application.NLP.FILL_MASK.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(model, translator);
        }
        if (Application.NLP.QUESTION_ANSWER.getPath().equals(applicationPath)) {
            return new CustomQuestionAnswerPredictor(model, translator);
        }
        if (Application.NLP.TEXT_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(model, translator);
        }
        if (Application.NLP.SENTIMENT_ANALYSIS.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(model, translator);
        }
        if (Application.NLP.TOKEN_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(model, translator);
        }
        if (Application.NLP.WORD_EMBEDDING.getPath().equals(applicationPath)) {
            return new CustomWordEmbeddingPredictor(model, translator);
        }
        if (Application.NLP.TEXT_GENERATION.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(model, translator);
        }
        if (Application.NLP.MACHINE_TRANSLATION.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(model, translator);
        }
        if (Application.NLP.MULTIPLE_CHOICE.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(model, translator);
        }
        if (Application.NLP.TEXT_EMBEDDING.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(model, translator);
        }
        if (Application.Tabular.LINEAR_REGRESSION.getPath().equals(applicationPath)) {
            return new CustomTabularPredictor(model, translator);
        }
        if (Application.Tabular.SOFTMAX_REGRESSION.getPath().equals(applicationPath)) {
            return new CustomTabularPredictor(model, translator);
        }
        if (Application.Audio.ANY.getPath().equals(applicationPath)) {
            return new CustomAudioPredictor(model, translator);
        }
        if (Application.TimeSeries.FORECASTING.getPath().equals(applicationPath)) {
            return new CustomForecastingPredictor(model, translator);
        }
        throw new RuntimeCamelException("Application not supported: " + applicationPath);
    }
}

