/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.component.disruptor.DisruptorComponent;
import org.apache.camel.component.disruptor.DisruptorReference;
import org.apache.camel.spi.annotations.Component;

@Component(value="disruptor-vm")
public class DisruptorVmComponent
extends DisruptorComponent {
    protected static final Map<String, DisruptorReference> DISRUPTORS = new HashMap<String, DisruptorReference>();
    private static final AtomicInteger START_COUNTER = new AtomicInteger();

    @Override
    public Map<String, DisruptorReference> getDisruptors() {
        return DISRUPTORS;
    }

    protected void doStart() throws Exception {
        super.doStart();
        START_COUNTER.incrementAndGet();
    }

    @Override
    protected void doStop() throws Exception {
        if (START_COUNTER.decrementAndGet() <= 0) {
            this.getDisruptors().clear();
        }
    }
}

