/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2.api;

import java.util.Map;
import java.util.Objects;
import org.apache.camel.RuntimeCamelException;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;
import org.hisp.dhis.integration.sdk.api.Dhis2Response;
import org.hisp.dhis.integration.sdk.api.operation.PostOperation;

public class Dhis2ResourceTables {
    private final Dhis2Client dhis2Client;

    public Dhis2ResourceTables(Dhis2Client dhis2Client) {
        this.dhis2Client = dhis2Client;
    }

    public void analytics(Boolean skipAggregate, Boolean skipEvents, Integer lastYears, Integer interval, Boolean async) {
        PostOperation postOperation = this.dhis2Client.post("resourceTables/analytics", new String[0]);
        if (skipEvents != null) {
            postOperation.withParameter("skipEvents", String.valueOf(skipEvents));
        }
        if (skipEvents != null) {
            postOperation.withParameter("skipAggregate", String.valueOf(skipAggregate));
        }
        if (lastYears != null) {
            postOperation.withParameter("lastYears", String.valueOf(lastYears));
        }
        Map webMessage = (Map)((Dhis2Response)postOperation.transfer()).returnAs(Map.class);
        String taskId = (String)((Map)webMessage.get("response")).get("id");
        if (async == null || !async.booleanValue()) {
            Map notification = null;
            while (notification == null || !((Boolean)notification.get("completed")).booleanValue()) {
                try {
                    Thread.sleep(Objects.requireNonNullElse(interval, 30000).intValue());
                }
                catch (InterruptedException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
                Iterable notifications = this.dhis2Client.get("system/tasks/ANALYTICS_TABLE/{taskId}", new String[]{taskId}).withoutPaging().transfer().returnAs(Map.class);
                if (!notifications.iterator().hasNext() || !(notification = (Map)notifications.iterator().next()).get("level").equals("ERROR")) continue;
                throw new RuntimeCamelException("Analytics failed => " + String.valueOf(notification));
            }
        }
    }
}

