/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2.api;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.dhis2.api.Dhis2Resource;
import org.apache.camel.component.dhis2.api.RootJunctionEnum;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;
import org.hisp.dhis.integration.sdk.api.Dhis2Response;
import org.hisp.dhis.integration.sdk.api.operation.GetOperation;

public class Dhis2Get {
    private final Dhis2Client dhis2Client;

    public Dhis2Get(Dhis2Client dhis2Client) {
        this.dhis2Client = dhis2Client;
    }

    public InputStream resource(String path, String fields, List<String> filter, RootJunctionEnum rootJunction, Map<String, Object> queryParams) {
        GetOperation getOperation = this.newGetOperation(path, fields, filter, rootJunction, queryParams);
        return ((Dhis2Response)getOperation.withParameter("paging", "false").transfer()).read();
    }

    protected GetOperation newGetOperation(String path, String fields, List<String> filters, RootJunctionEnum rootJunction, Map<String, Object> queryParams) {
        GetOperation getOperation = this.dhis2Client.get(path, new String[0]);
        if (fields != null) {
            getOperation.withFields(new String[]{fields});
        }
        if (filters != null) {
            for (String string : filters) {
                getOperation.withFilter(string);
            }
        }
        if (rootJunction != null) {
            if (rootJunction.equals((Object)RootJunctionEnum.AND)) {
                getOperation.withAndRootJunction();
            } else {
                getOperation.withOrRootJunction();
            }
        }
        if (queryParams != null) {
            for (Map.Entry entry : queryParams.entrySet()) {
                if (entry.getValue() instanceof List) {
                    for (String queryValue : (List)entry.getValue()) {
                        getOperation.withParameter((String)entry.getKey(), queryValue);
                    }
                    continue;
                }
                getOperation.withParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return getOperation;
    }

    public Iterator<Dhis2Resource> collection(String path, String arrayName, Boolean paging, String fields, List<String> filter, RootJunctionEnum rootJunction, Map<String, Object> queryParams) {
        GetOperation getOperation = this.newGetOperation(path, fields, filter, rootJunction, queryParams);
        Object iteratorDhis2Response = paging != null && paging != false ? getOperation.withPaging().transfer() : getOperation.withoutPaging().transfer();
        return iteratorDhis2Response.returnAs(Dhis2Resource.class, arrayName).iterator();
    }
}

