/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.component.debezium.DebeziumComponent;
import org.apache.camel.component.debezium.DebeziumConstants;
import org.apache.camel.component.debezium.DebeziumEndpoint;
import org.apache.camel.component.debezium.DebeziumPostgresComponent;
import org.apache.camel.component.debezium.configuration.PostgresConnectorEmbeddedDebeziumConfiguration;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="3.0.0", scheme="debezium-postgres", title="Debezium PostgresSQL Connector", syntax="debezium-postgres:name", category={Category.DATABASE}, consumerOnly=true, headersClass=DebeziumConstants.class)
public final class DebeziumPostgresEndpoint
extends DebeziumEndpoint<PostgresConnectorEmbeddedDebeziumConfiguration>
implements EndpointServiceLocation {
    @UriParam
    private PostgresConnectorEmbeddedDebeziumConfiguration configuration;

    public DebeziumPostgresEndpoint(String uri, DebeziumPostgresComponent component, PostgresConnectorEmbeddedDebeziumConfiguration configuration) {
        super(uri, (DebeziumComponent)component);
        this.configuration = configuration;
    }

    public DebeziumPostgresEndpoint() {
    }

    public String getServiceUrl() {
        return this.configuration.getDatabaseHostname() + ":" + this.configuration.getDatabasePort();
    }

    public String getServiceProtocol() {
        return "jdbc";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getDatabaseUser() != null) {
            return Map.of("username", this.configuration.getDatabaseUser());
        }
        return null;
    }

    public PostgresConnectorEmbeddedDebeziumConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PostgresConnectorEmbeddedDebeziumConfiguration configuration) {
        this.configuration = configuration;
    }
}

