/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DebeziumMongodbEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "debezium-mongodb".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "name", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(63);
        props.add("additionalProperties");
        props.add("bridgeErrorHandler");
        props.add("captureMode");
        props.add("collectionExcludeList");
        props.add("collectionIncludeList");
        props.add("connectBackoffInitialDelayMs");
        props.add("connectBackoffMaxDelayMs");
        props.add("connectMaxAttempts");
        props.add("converters");
        props.add("cursorMaxAwaitTimeMs");
        props.add("databaseExcludeList");
        props.add("databaseHistoryFileFilename");
        props.add("databaseIncludeList");
        props.add("eventProcessingFailureHandlingMode");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("fieldExcludeList");
        props.add("fieldRenames");
        props.add("heartbeatIntervalMs");
        props.add("heartbeatTopicsPrefix");
        props.add("internalKeyConverter");
        props.add("internalValueConverter");
        props.add("maxBatchSize");
        props.add("maxQueueSize");
        props.add("maxQueueSizeInBytes");
        props.add("mongodbAuthsource");
        props.add("mongodbConnectTimeoutMs");
        props.add("mongodbHosts");
        props.add("mongodbMembersAutoDiscover");
        props.add("mongodbName");
        props.add("mongodbPassword");
        props.add("mongodbPollIntervalMs");
        props.add("mongodbServerSelectionTimeoutMs");
        props.add("mongodbSocketTimeoutMs");
        props.add("mongodbSslEnabled");
        props.add("mongodbSslInvalidHostnameAllowed");
        props.add("mongodbUser");
        props.add("name");
        props.add("offsetCommitPolicy");
        props.add("offsetCommitTimeoutMs");
        props.add("offsetFlushIntervalMs");
        props.add("offsetStorage");
        props.add("offsetStorageFileName");
        props.add("offsetStoragePartitions");
        props.add("offsetStorageReplicationFactor");
        props.add("offsetStorageTopic");
        props.add("pollIntervalMs");
        props.add("provideTransactionMetadata");
        props.add("queryFetchSize");
        props.add("retriableRestartConnectorWaitMs");
        props.add("sanitizeFieldNames");
        props.add("schemaNameAdjustmentMode");
        props.add("signalDataCollection");
        props.add("skippedOperations");
        props.add("snapshotCollectionFilterOverrides");
        props.add("snapshotDelayMs");
        props.add("snapshotFetchSize");
        props.add("snapshotIncludeCollectionList");
        props.add("snapshotMaxThreads");
        props.add("snapshotMode");
        props.add("sourceStructVersion");
        props.add("tombstonesOnDelete");
        props.add("transactionTopic");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("additionalProperties.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

