/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.common.header.CxfHeaderHelper;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCxfRsBinding
implements CxfRsBinding,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCxfRsBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    @Override
    public Object populateCxfRsResponseFromExchange(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) throws Exception {
        Message response;
        if (camelExchange.isFailed() && camelExchange.getException() != null) {
            throw camelExchange.getException();
        }
        if (camelExchange.getPattern().isOutCapable()) {
            if (camelExchange.hasOut()) {
                response = camelExchange.getOut();
                LOG.trace("Get the response from the out message");
            } else {
                response = camelExchange.getIn();
                LOG.trace("Get the response from the in message as a fallback");
            }
        } else {
            response = camelExchange.getIn();
            LOG.trace("Get the response from the in message");
        }
        Object o = response.getBody();
        if (!(o instanceof Response)) {
            if (response.getHeader(org.apache.cxf.message.Message.PROTOCOL_HEADERS) != null) {
                Map headers = CastUtils.cast((Map)((Map)response.getHeader(org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
                if (!ObjectHelper.isEmpty((Object)cxfExchange) && !ObjectHelper.isEmpty((Object)cxfExchange.getOutMessage())) {
                    cxfExchange.getOutMessage().putIfAbsent((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, new TreeMap(String.CASE_INSENSITIVE_ORDER));
                }
                Map cxfHeaders = CastUtils.cast((Map)((Map)cxfExchange.getOutMessage().get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
                for (Map.Entry ent : headers.entrySet()) {
                    List<String> v = ent.getValue() instanceof List ? CastUtils.cast((List)((List)ent.getValue())) : Arrays.asList(ent.getValue().toString());
                    cxfHeaders.put(ent.getKey(), v);
                }
            }
            if (response.getHeader("CamelHttpResponseCode") != null && !cxfExchange.containsKey((Object)org.apache.cxf.message.Message.RESPONSE_CODE)) {
                cxfExchange.put((Object)org.apache.cxf.message.Message.RESPONSE_CODE, response.getHeader("CamelHttpResponseCode", Integer.class));
            }
            if (response.getHeader("Content-Type") != null && !cxfExchange.containsKey((Object)"Content-Type")) {
                Map cxfHeaders;
                if (!ObjectHelper.isEmpty((Object)cxfExchange) && !ObjectHelper.isEmpty((Object)cxfExchange.getOutMessage())) {
                    cxfExchange.getOutMessage().putIfAbsent((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, new TreeMap(String.CASE_INSENSITIVE_ORDER));
                }
                if (!(cxfHeaders = CastUtils.cast((Map)((Map)cxfExchange.getOutMessage().get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)))).containsKey("Content-Type")) {
                    List<String> a = Arrays.asList((String)response.getHeader("Content-Type"));
                    cxfHeaders.put("Content-Type", a);
                    cxfExchange.getOutMessage().put((Object)"Content-Type", response.getHeader("Content-Type"));
                }
            }
        }
        return o;
    }

    @Override
    public void populateExchangeFromCxfRsRequest(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange, Method method, Object[] paramArray) {
        Message camelMessage = camelExchange.getIn();
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        CxfHeaderHelper.copyHttpHeadersFromCxfToCamel((HeaderFilterStrategy)this.headerFilterStrategy, (org.apache.cxf.message.Message)cxfMessage, (Message)camelMessage, (Exchange)camelExchange);
        this.setCharsetWithContentType(camelExchange);
        this.copyProtocolHeader(cxfMessage, camelMessage, camelMessage.getExchange());
        camelMessage.setHeader("CamelCxfRsResponseClass", method.getReturnType());
        camelMessage.setHeader("CamelCxfRsResponseGenericType", (Object)method.getGenericReturnType());
        this.copyOperationResourceInfoStack(cxfMessage, camelMessage);
        camelMessage.setHeader("operationName", (Object)method.getName());
        camelMessage.setHeader("CamelCxfMessage", (Object)cxfMessage);
        camelMessage.setBody((Object)new MessageContentsList(paramArray));
        SecurityContext securityContext = (SecurityContext)cxfMessage.get(SecurityContext.class);
        if (securityContext instanceof LoginSecurityContext && ((LoginSecurityContext)securityContext).getSubject() != null) {
            camelExchange.getIn().getHeaders().put("CamelAuthentication", ((LoginSecurityContext)securityContext).getSubject());
        } else if (securityContext != null && securityContext.getUserPrincipal() != null) {
            Subject subject = new Subject();
            subject.getPrincipals().add(securityContext.getUserPrincipal());
            camelExchange.getIn().getHeaders().put("CamelAuthentication", subject);
        }
    }

    protected void setCharsetWithContentType(Exchange camelExchange) {
        String charset;
        String normalizedEncoding;
        String contentTypeHeader = ExchangeHelper.getContentType((Exchange)camelExchange);
        if (contentTypeHeader != null && (normalizedEncoding = HttpHeaderHelper.mapCharset((String)(charset = HttpHeaderHelper.findCharset((String)contentTypeHeader)), (String)Charset.forName("UTF-8").name())) != null) {
            camelExchange.setProperty("CamelCharsetName", (Object)normalizedEncoding);
        }
    }

    @Override
    public MultivaluedMap<String, String> bindCamelHeadersToRequestHeaders(Map<String, Object> camelHeaders, Exchange camelExchange) throws Exception {
        MetadataMap answer = new MetadataMap();
        CxfHeaderHelper.propagateCamelHeadersToCxfHeaders((HeaderFilterStrategy)this.headerFilterStrategy, camelHeaders, (Map)answer, (Exchange)camelExchange);
        return answer;
    }

    @Override
    public Object bindCamelMessageBodyToRequestBody(Message camelMessage, Exchange camelExchange) throws Exception {
        Object request = camelMessage.getBody(MessageContentsList.class);
        if (request != null) {
            return ((MessageContentsList)request).get(0);
        }
        request = camelMessage.getBody();
        if (request instanceof List) {
            request = ((List)request).get(0);
        } else if (request != null && request.getClass().isArray()) {
            request = ((Object[])request)[0];
        }
        return request;
    }

    @Override
    public Map<String, Object> bindResponseHeadersToCamelHeaders(Object response, Exchange camelExchange) throws Exception {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        if (response instanceof Response) {
            MultivaluedMap responseHeaders = ((Response)response).getMetadata();
            CxfHeaderHelper.propagateCxfHeadersToCamelHeaders((HeaderFilterStrategy)this.headerFilterStrategy, (Map)responseHeaders, answer, (Exchange)camelExchange);
        }
        return answer;
    }

    @Override
    public Entity<Object> bindCamelMessageToRequestEntity(Object body, Message camelMessage, Exchange camelExchange) throws Exception {
        if (body == null) {
            return null;
        }
        String contentType = (String)camelMessage.getHeader("Content-Type", String.class);
        if (contentType == null) {
            contentType = "*/*";
        }
        String contentEncoding = (String)camelMessage.getHeader("Content-Encoding", String.class);
        return Entity.entity((Object)body, (Variant)new Variant(MediaType.valueOf((String)contentType), Locale.US, contentEncoding));
    }

    @Override
    public Object bindResponseToCamelBody(Object response, Exchange camelExchange) throws Exception {
        return response;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    protected void copyProtocolHeader(org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange camelExchange) {
        Map headers = (Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS);
        for (Map.Entry entry : headers.entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), camelExchange) || ((List)entry.getValue()).isEmpty()) {
                LOG.trace("Drop CXF message protocol header: {}={}", entry.getKey(), entry.getValue());
                continue;
            }
            camelMessage.setHeader((String)entry.getKey(), ((List)entry.getValue()).get(0));
        }
    }

    protected void copyOperationResourceInfoStack(org.apache.cxf.message.Message cxfMessage, Message camelMessage) {
        OperationResourceInfoStack stack = (OperationResourceInfoStack)cxfMessage.get(OperationResourceInfoStack.class);
        if (stack != null) {
            OperationResourceInfoStack copyStack = (OperationResourceInfoStack)stack.clone();
            camelMessage.setHeader("CamelCxfRsOperationResourceInfoStack", (Object)copyStack);
        }
    }
}

