/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.slf4j.Logger;

public abstract class AbstractDataFormatFeature
extends AbstractFeature {
    protected static final Collection<Class<?>> REMOVING_FAULT_IN_INTERCEPTORS = new ArrayList();
    protected Set<String> inInterceptorNames = new HashSet<String>();
    protected Set<String> outInterceptorNames = new HashSet<String>();

    protected abstract Logger getLogger();

    protected void removeInterceptorWhichIsOutThePhases(List<Interceptor<? extends Message>> interceptors, String[] phaseNames, Set<String> needToBeKept) {
        for (Interceptor<? extends Message> i : interceptors) {
            boolean outside = false;
            if (!(i instanceof PhaseInterceptor)) continue;
            PhaseInterceptor p = (PhaseInterceptor)i;
            for (String phaseName : phaseNames) {
                if (!p.getPhase().equals(phaseName)) continue;
                outside = true;
                break;
            }
            if (outside) continue;
            if (needToBeKept == null) {
                this.getLogger().info("removing the interceptor " + p);
                interceptors.remove(p);
                continue;
            }
            if (needToBeKept.contains(p.getClass().getName())) continue;
            this.getLogger().info("removing the interceptor " + p);
            interceptors.remove(p);
        }
    }

    protected void removeInterceptors(List<Interceptor<? extends Message>> interceptors, Collection<Class<?>> toBeRemovedInterceptors) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!toBeRemovedInterceptors.contains(interceptor.getClass())) continue;
            this.getLogger().info("removing the interceptor " + interceptor);
            interceptors.remove(interceptor);
        }
    }

    protected void removeInterceptor(List<Interceptor<? extends Message>> interceptors, Class<? extends Interceptor<? extends Message>> cls) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!interceptor.getClass().equals(cls)) continue;
            interceptors.remove(interceptor);
        }
    }

    protected void removeFaultInInterceptorFromClient(Client client) {
        this.removeInterceptors(client.getInFaultInterceptors(), REMOVING_FAULT_IN_INTERCEPTORS);
        this.removeInterceptors(client.getEndpoint().getService().getInFaultInterceptors(), REMOVING_FAULT_IN_INTERCEPTORS);
        this.removeInterceptors(client.getEndpoint().getInFaultInterceptors(), REMOVING_FAULT_IN_INTERCEPTORS);
        this.removeInterceptors(client.getEndpoint().getBinding().getInFaultInterceptors(), REMOVING_FAULT_IN_INTERCEPTORS);
    }

    public void addInIntercepters(List<Interceptor<? extends Message>> interceptors) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            this.inInterceptorNames.add(interceptor.getClass().getName());
        }
    }

    public void addOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            this.outInterceptorNames.add(interceptor.getClass().getName());
        }
    }

    public Set<String> getInInterceptorNames() {
        return this.inInterceptorNames;
    }

    public Set<String> getOutInterceptorNames() {
        return this.outInterceptorNames;
    }

    static {
        REMOVING_FAULT_IN_INTERCEPTORS.add(ClientFaultConverter.class);
    }
}

