/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.spring.jaxws;

import jakarta.xml.ws.Provider;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.common.DataFormat;
import org.apache.camel.component.cxf.jaxws.CxfComponent;
import org.apache.camel.component.cxf.jaxws.CxfEndpoint;
import org.apache.camel.component.cxf.jaxws.DefaultPayloadProviderSEI;
import org.apache.camel.component.cxf.jaxws.DefaultSEI;
import org.apache.camel.component.cxf.jaxws.WSDLServiceFactoryBean;
import org.apache.camel.component.cxf.spring.jaxws.CxfSpringEndpointUtils;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.AbstractApplicationContext;

public class CxfSpringEndpoint
extends CxfEndpoint
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CxfSpringEndpoint.class);
    private String beanId;
    private ApplicationContext applicationContext;

    public CxfSpringEndpoint(CxfComponent component, String address) {
        super(address, component);
    }

    public CxfSpringEndpoint() {
    }

    public Client createClient() throws Exception {
        Class cls = this.getServiceClass();
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notNull((Object)cls, (String)"serviceClass");
        }
        if (this.getWsdlURL() == null && cls == null) {
            this.setServiceClass(DefaultSEI.class.getName());
            this.setDefaultOperationNamespace("http://camel.apache.org/cxf/jaxws/dispatch");
            this.setDefaultOperationName("Invoke");
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setSkipPayloadMessagePartCheck(true);
            }
            cls = this.getServiceClass();
        }
        ClientFactoryBean factoryBean = cls != null ? this.createClientFactoryBean(cls) : this.createClientFactoryBean();
        this.setupClientFactoryBean(factoryBean, cls);
        QName serviceQName = null;
        try {
            serviceQName = factoryBean.getServiceName();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (serviceQName == null && this.getServiceLocalName() != null) {
            factoryBean.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
        }
        if (factoryBean.getEndpointName() == null && this.getEndpointLocalName() != null) {
            factoryBean.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
        }
        if (cls == null) {
            this.checkName(factoryBean.getEndpointName(), "endpoint/port name");
            this.checkName(factoryBean.getServiceName(), "service name");
        }
        Client client = factoryBean.create();
        this.setupHandlers(factoryBean, client);
        return client;
    }

    protected ServerFactoryBean createServerFactoryBean() throws Exception {
        Class<Provider> cls = this.getServiceClass();
        if (this.getWsdlURL() == null && cls == null) {
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setServiceClass(DefaultPayloadProviderSEI.class.getName());
            }
            cls = this.getServiceClass();
        }
        Object answer = null;
        if (cls == null) {
            if (!this.getDataFormat().equals((Object)DataFormat.POJO)) {
                answer = new JaxWsServerFactoryBean((JaxWsServiceFactoryBean)new WSDLServiceFactoryBean());
                cls = Provider.class;
            } else {
                ObjectHelper.notNull((Object)cls, (String)"serviceClass");
            }
        } else {
            answer = CxfSpringEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        if (answer.getServiceName() == null && this.getServiceLocalName() != null) {
            answer.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
        }
        if (answer.getEndpointName() == null && this.getEndpointLocalName() != null) {
            answer.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
        }
        this.checkName(answer.getEndpointName(), "endpoint/port name");
        this.checkName(answer.getServiceName(), "service name");
        return answer;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String id) {
        this.beanId = id;
    }

    public void setServiceNamespace(String serviceNamespace) {
        QName qn = this.getServiceNameAsQName();
        if (qn == null) {
            this.setServiceNameAsQName(new QName(serviceNamespace, "local"));
        } else {
            this.setServiceNameAsQName(new QName(serviceNamespace, qn.getLocalPart()));
        }
    }

    public String getServiceNamespace() {
        QName qn = this.getServiceNameAsQName();
        if (qn == null) {
            return null;
        }
        return qn.getNamespaceURI();
    }

    public void setServiceLocalName(String serviceLocalName) {
        QName qn = this.getServiceNameAsQName();
        if (qn == null) {
            this.setServiceNameAsQName(new QName("", serviceLocalName));
        } else {
            this.setServiceNameAsQName(new QName(qn.getNamespaceURI(), serviceLocalName));
        }
    }

    public String getServiceLocalName() {
        QName qn = this.getServiceNameAsQName();
        if (qn == null) {
            return null;
        }
        return qn.getLocalPart();
    }

    public String getEndpointLocalName() {
        QName qn = this.getPortNameAsQName();
        if (qn == null) {
            return null;
        }
        return qn.getLocalPart();
    }

    public void setEndpointLocalName(String endpointLocalName) {
        QName qn = this.getPortNameAsQName();
        if (qn == null) {
            this.setPortNameAsQName(new QName("", endpointLocalName));
        } else {
            this.setPortNameAsQName(new QName(qn.getNamespaceURI(), endpointLocalName));
        }
    }

    public void setEndpointNamespace(String endpointNamespace) {
        QName qn = this.getPortNameAsQName();
        if (qn == null) {
            this.setPortNameAsQName(new QName(endpointNamespace, "local"));
        } else {
            this.setPortNameAsQName(new QName(endpointNamespace, qn.getLocalPart()));
        }
    }

    public String getEndpointNamespace() {
        QName qn = this.getPortNameAsQName();
        if (qn == null) {
            return null;
        }
        return qn.getNamespaceURI();
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.applicationContext = ctx;
        if (this.bus == null) {
            this.createBus = true;
            this.bus = BusWiringBeanFactoryPostProcessor.addDefaultBus((ApplicationContext)ctx);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = this.createBus(this.getCamelContext());
            this.enableSpringBusShutdownGracefully(this.bus);
            this.createBus = true;
            LOG.debug("Using DefaultBus {}", (Object)this.bus);
        }
        if (!this.getBusHasBeenCalled.getAndSet(true) && this.defaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
            LOG.debug("Set bus {} as thread default bus", (Object)this.bus);
        }
        return this.bus;
    }

    private Bus createBus(CamelContext context) {
        BusFactory busFactory = BusFactory.newInstance();
        if (context instanceof SpringCamelContext) {
            SpringCamelContext springCamelContext = (SpringCamelContext)context;
            busFactory = new SpringBusFactory(springCamelContext.getApplicationContext());
        }
        return busFactory.createBus();
    }

    private void enableSpringBusShutdownGracefully(final Bus bus) {
        if (bus instanceof SpringBus && this.applicationContext instanceof AbstractApplicationContext) {
            final SpringBus springBus = (SpringBus)bus;
            AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)this.applicationContext;
            ApplicationListener cxfSpringBusListener = null;
            for (ApplicationListener listener : abstractApplicationContext.getApplicationListeners()) {
                if (listener.getClass().getName().indexOf("org.apache.cxf.bus.spring.SpringBus") < 0) continue;
                cxfSpringBusListener = listener;
            }
            ApplicationEventMulticaster aem = (ApplicationEventMulticaster)this.applicationContext.getBean("applicationEventMulticaster", ApplicationEventMulticaster.class);
            aem.removeApplicationListener(cxfSpringBusListener);
            abstractApplicationContext.addApplicationListener(event -> new Thread(){

                @Override
                public void run() {
                    if (event instanceof ContextClosedEvent && bus.getState() == Bus.BusState.RUNNING) {
                        try {
                            boolean done = false;
                            ShutdownStrategy shutdownStrategy = ((DefaultCamelContext)CxfSpringEndpoint.this.getCamelContext()).getShutdownStrategy();
                            while (!done && !shutdownStrategy.hasTimeoutOccurred()) {
                                int inflight = CxfSpringEndpoint.this.getCamelContext().getInflightRepository().size();
                                if (inflight != 0) {
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                done = true;
                            }
                        }
                        catch (Exception e) {
                            LOG.debug("Error when enabling SpringBus shutdown gracefully", (Throwable)e);
                        }
                        springBus.onApplicationEvent(event);
                    } else {
                        springBus.onApplicationEvent(event);
                    }
                }
            }.start());
        }
    }
}

