/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common.message;

import org.apache.camel.spi.Metadata;
import org.apache.cxf.message.Message;

public final class CxfConstants {
    public static final String SCHEME_CXF = "cxf";
    public static final String SCHEME_CXF_RS = "cxfrs";
    public static final String METHOD = "method";
    public static final String SERVICE_CLASS = "serviceClass";
    public static final String DATA_FORMAT_PROPERTY = "CamelCXFDataFormat";
    public static final String SET_DEFAULT_BUS = "setDefaultBus";
    public static final String WSDL_URL = "wsdlURL";
    public static final String ADDRESS = "address";
    public static final String SERVICE_NAME = "serviceName";
    public static final String PORT_NAME = "portName";
    public static final String SERVICE_LOCALNAME = "serviceLocalName";
    public static final String SERVICE_NAMESPACE = "serviceNamespace";
    public static final String PORT_LOCALNAME = "endpointLocalName";
    public static final String PORT_NAMESPACE = "endpointNamespace";
    public static final String PROTOCOL_NAME_RES = "res";
    @Metadata(description="The name of the operation.", javaType="String")
    public static final String OPERATION_NAME = "operationName";
    @Metadata(description="The operation namespace.", javaType="String", applicableFor={"cxf"})
    public static final String OPERATION_NAMESPACE = "operationNamespace";
    public static final String SPRING_CONTEXT_ENDPOINT = "bean:";
    @Metadata(description="The destination override url", javaType="String", applicableFor={"cxf"})
    public static final String DESTINATION_OVERRIDE_URL = "CamelDestinationOverrideUrl";
    @Metadata(description="The response context", javaType="Map<String, Object>", applicableFor={"cxf"})
    public static final String RESPONSE_CONTEXT = "ResponseContext";
    @Metadata(description="The authentication", javaType="javax.security.auth.Subject")
    public static final String AUTHENTICATION = "CamelAuthentication";
    @Metadata(description="The request context", javaType="Object", applicableFor={"cxf"})
    public static final String REQUEST_CONTEXT = "RequestContext";
    public static final String JAXWS_CONTEXT = "jaxwsContext";
    public static final String DISPATCH_NAMESPACE = "http://camel.apache.org/cxf/jaxws/dispatch";
    public static final String DISPATCH_DEFAULT_OPERATION_NAMESPACE = "Invoke";
    @Metadata(description="The http method to use", javaType="String", applicableFor={"cxfrs"})
    public static final String HTTP_METHOD = "CamelHttpMethod";
    @Metadata(description="The http path", javaType="String", applicableFor={"cxfrs"})
    public static final String HTTP_PATH = "CamelHttpPath";
    @Metadata(description="The content type", javaType="String", applicableFor={"cxfrs"})
    public static final String CONTENT_TYPE = "Content-Type";
    @Metadata(description="The http query", javaType="String", applicableFor={"cxfrs"})
    public static final String HTTP_QUERY = "CamelHttpQuery";
    @Metadata(description="The http response code", javaType="Integer", applicableFor={"cxfrs"})
    public static final String HTTP_RESPONSE_CODE = "CamelHttpResponseCode";
    @Metadata(description="The content encoding", javaType="String", applicableFor={"cxfrs"})
    public static final String CONTENT_ENCODING = "Content-Encoding";
    @Metadata(description="The protocol headers", javaType="Map", applicableFor={"cxfrs"})
    public static final String PROTOCOL_HEADERS = Message.PROTOCOL_HEADERS;
    @Metadata(description="The CXF message", javaType="org.apache.cxf.message.Message", applicableFor={"cxfrs"})
    public static final String CAMEL_CXF_MESSAGE = "CamelCxfMessage";
    @Metadata(description="If it is true, the CxfRsProducer will use the HttpClientAPI to invoke the service. If it is false, the\n CxfRsProducer will use the ProxyClientAPI to invoke the service", javaType="Boolean", applicableFor={"cxfrs"})
    public static final String CAMEL_CXF_RS_USING_HTTP_API = "CamelCxfRsUsingHttpAPI";
    @Metadata(description="The path values", javaType="Object[]", applicableFor={"cxfrs"})
    public static final String CAMEL_CXF_RS_VAR_VALUES = "CamelCxfRsVarValues";
    @Metadata(description="The response class", javaType="Class", applicableFor={"cxfrs"})
    public static final String CAMEL_CXF_RS_RESPONSE_CLASS = "CamelCxfRsResponseClass";
    @Metadata(description="The response generic type", javaType="Type", applicableFor={"cxfrs"})
    public static final String CAMEL_CXF_RS_RESPONSE_GENERIC_TYPE = "CamelCxfRsResponseGenericType";
    @Metadata(description="The query map", javaType="Map<String, String>", applicableFor={"cxfrs"})
    public static final String CAMEL_CXF_RS_QUERY_MAP = "CamelCxfRsQueryMap";
    public static final String CAMEL_CXF_RS_EXTRACT_ENTITY = "CamelCxfRsExtractEntity";
    @Metadata(description="The stack of MethodInvocationInfo representing resources path when JAX-RS invocation looks for target.", javaType="org.apache.cxf.jaxrs.model.OperationResourceInfoStack", applicableFor={"cxfrs"})
    public static final String CAMEL_CXF_RS_OPERATION_RESOURCE_INFO_STACK = "CamelCxfRsOperationResourceInfoStack";
    public static final String CAMEL_CXF_ATTACHMENTS = "CamelAttachments";
    public static final String CAMEL_CXF_RS_THROW_EXCEPTION_ON_FAILURE = "CamelCxfRsThrowExceptionOnFailure";
    public static final String WSA_HEADERS_INBOUND = "javax.xml.ws.addressing.context.inbound";
    public static final String WSA_HEADERS_OUTBOUND = "javax.xml.ws.addressing.context.outbound";
    public static final String CAMEL_CXF_PROTOCOL_HEADERS_MERGED = "CamelCxfProtocolHeadersMerged";

    private CxfConstants() {
    }
}

