/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.component.crypto.DigitalSignatureEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="crypto")
public class DigitalSignatureComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private DigitalSignatureConfiguration configuration = new DigitalSignatureConfiguration();

    public DigitalSignatureComponent() {
    }

    public DigitalSignatureComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext");
        DigitalSignatureConfiguration config = this.getConfiguration().copy();
        config.setCamelContext(this.getCamelContext());
        try {
            config.setCryptoOperation(new URI(remaining).getScheme());
        }
        catch (Exception e) {
            throw new MalformedURLException(String.format("An invalid crypto uri was provided '%s'. Check the uri matches the format crypto:sign or crypto:verify", uri));
        }
        DigitalSignatureEndpoint endpoint = new DigitalSignatureEndpoint(uri, this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public DigitalSignatureConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DigitalSignatureConfiguration configuration) {
        this.configuration = configuration;
    }
}

