/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.sig;

import java.io.Closeable;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsFormatException;
import org.apache.camel.component.crypto.cms.sig.SignedDataVerifier;
import org.apache.camel.component.crypto.cms.sig.SignedDataVerifierConfiguration;
import org.apache.camel.util.IOHelper;
import org.apache.commons.codec.binary.Base64InputStream;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedDataVerifierFromHeader
extends SignedDataVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDataVerifierFromHeader.class);
    private SignedDataVerifierConfiguration conf;

    public SignedDataVerifierFromHeader(SignedDataVerifierConfiguration conf) {
        super(conf);
        this.conf = conf;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        InputStream signature = (InputStream)exchange.getIn().getHeader("CamelCryptoCmsSignedData", InputStream.class);
        if (signature == null) {
            LOG.debug("No signed data found in header {}. Assuming signed data contained in message body", (Object)"CamelCryptoCmsSignedData");
            super.process(exchange);
        } else {
            LOG.debug("Signed data header {} found.", (Object)"CamelCryptoCmsSignedData");
            this.processSignedDataHeader(exchange, signature);
            exchange.getIn().removeHeader("CamelCryptoCmsSignedData");
        }
    }

    protected void processSignedDataHeader(Exchange exchange, InputStream signature) throws Exception {
        if (this.conf.isSignedDataHeaderBase64(exchange).booleanValue()) {
            signature = new Base64InputStream(signature);
        }
        InputStream stream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        try {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            if (this.conf.isFromBase64(exchange).booleanValue()) {
                stream = new Base64InputStream(stream);
            }
            this.unmarshalInternal(stream, signature, exchange);
        }
        catch (Exception e) {
            exchange.setOut(null);
            throw e;
        }
        finally {
            IOHelper.close((Closeable)stream, (String)"input stream");
        }
    }

    protected void unmarshalInternal(InputStream is, InputStream signature, Exchange exchange) throws Exception {
        CMSSignedDataParser sp;
        try {
            sp = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build(), new CMSTypedStream(is), signature);
        }
        catch (CMSException e) {
            throw new CryptoCmsFormatException(this.getFormatErrorMessage(), e);
        }
        try {
            sp.getSignedContent().drain();
        }
        catch (NullPointerException e) {
            throw this.getContentMissingException(e);
        }
        LOG.debug("Signed data found");
        this.debugLog(sp);
        this.verify(sp, exchange);
    }
}

