/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.crypt;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import org.apache.camel.Exchange;
import org.apache.camel.component.crypto.cms.common.AttributesGeneratorProvider;
import org.apache.camel.component.crypto.cms.common.CryptoCmsMarshallerAbstract;
import org.apache.camel.component.crypto.cms.common.OriginatorInformationProvider;
import org.apache.camel.component.crypto.cms.crypt.EnvelopedDataEncryptorConfiguration;
import org.apache.camel.component.crypto.cms.crypt.RecipientInfo;
import org.apache.camel.component.crypto.cms.crypt.TransRecipientInfo;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.util.IOHelper;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.OriginatorInformation;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvelopedDataEncryptor
extends CryptoCmsMarshallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(EnvelopedDataEncryptor.class);
    private final EnvelopedDataEncryptorConfiguration conf;

    public EnvelopedDataEncryptor(EnvelopedDataEncryptorConfiguration conf) {
        super(conf);
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void marshalInternal(InputStream is, OutputStream os, Exchange exchange) throws Exception {
        LOG.debug("Content encryption algorithm: {}", (Object)this.conf.getAlgorithmID());
        LOG.debug("Parameter secretKeyLength: {}", (Object)this.conf.getSecretKeyLength());
        OutputStream encryptingStream = null;
        try {
            AttributesGeneratorProvider attributeGeneratorProvider;
            CMSEnvelopedDataStreamGenerator gen = new CMSEnvelopedDataStreamGenerator();
            OriginatorInformationProvider originatorInformationProvider = this.conf.getOriginatorInformationProvider();
            if (originatorInformationProvider != null) {
                LOG.debug("originatorInformationProvider found");
                OriginatorInformation originatorInformation = originatorInformationProvider.getOriginatorInformation(exchange);
                if (originatorInformation != null) {
                    LOG.debug("originatorInformation found");
                    gen.setOriginatorInfo(originatorInformation);
                }
            }
            if ((attributeGeneratorProvider = this.conf.getUnprotectedAttributesGeneratorProvider()) != null) {
                LOG.debug("attributeGeneratorProvider found");
                gen.setUnprotectedAttributeGenerator(attributeGeneratorProvider.getAttributesGenerator(exchange));
            }
            if (this.conf.getRecipient().isEmpty()) {
                throw new CryptoCmsException("No recipient configured.");
            }
            for (RecipientInfo recipientInfo : this.conf.getRecipient()) {
                TransRecipientInfo keyTransrecipientInfo = (TransRecipientInfo)recipientInfo;
                LOG.debug("Recipient info: {}", (Object)keyTransrecipientInfo);
                X509Certificate encryptCert = keyTransrecipientInfo.getCertificate(exchange);
                LOG.debug("Encryption certificate for recipient with '{}' : {}", (Object)keyTransrecipientInfo, (Object)encryptCert);
                AlgorithmIdentifier keyEncryptionAlgorithm = this.determineKeyEncryptionAlgorithmIdentifier(keyTransrecipientInfo.getKeyEncryptionAlgorithm(exchange), keyTransrecipientInfo);
                JceKeyTransRecipientInfoGenerator keyTransRecipeintInfoGen = new JceKeyTransRecipientInfoGenerator(encryptCert, keyEncryptionAlgorithm);
                keyTransRecipeintInfoGen.setProvider("BC");
                gen.addRecipientInfoGenerator((RecipientInfoGenerator)keyTransRecipeintInfoGen);
            }
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(this.conf.getAlgorithmID()).setProvider("BC").build();
            encryptingStream = gen.open(os, encryptor);
            IOHelper.copy((InputStream)is, (OutputStream)encryptingStream);
            LOG.debug("CMS Enveloped Data creation successful");
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable)is);
            IOHelper.close(encryptingStream);
            throw throwable;
        }
        IOHelper.close((Closeable)is);
        IOHelper.close((Closeable)encryptingStream);
    }

    private AlgorithmIdentifier determineKeyEncryptionAlgorithmIdentifier(String keyEncryptionAlgorithm, TransRecipientInfo keyTransRecipient) throws CryptoCmsException {
        if (keyEncryptionAlgorithm == null) {
            throw new CryptoCmsException("Key encryption algorithm  of recipient info '" + keyTransRecipient + "' is missing");
        }
        if ("RSA".equals(keyEncryptionAlgorithm)) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
        }
        throw new CryptoCmsException("Key encryption algorithm '" + keyEncryptionAlgorithm + "' of recipient info '" + keyTransRecipient + "' is not supported");
    }
}

