/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.common;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.crypto.cms.common.CryptoCmsMarshallerConfiguration;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.camel.util.IOHelper;
import org.apache.commons.codec.binary.Base64OutputStream;

public abstract class CryptoCmsMarshallerAbstract
implements Processor {
    private final CryptoCmsMarshallerConfiguration config;

    public CryptoCmsMarshallerAbstract(CryptoCmsMarshallerConfiguration config) {
        this.config = config;
    }

    public CryptoCmsMarshallerConfiguration getConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        OutputStreamBuilder output = OutputStreamBuilder.withExchange((Exchange)exchange);
        Object outStream = this.config.getToBase64() != false ? new Base64OutputStream((OutputStream)output) : output;
        InputStream body = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        Message out = exchange.getOut();
        out.copyFrom(exchange.getIn());
        try {
            try {
                this.marshalInternal(body, (OutputStream)outStream, exchange);
            }
            finally {
                IOHelper.close((Closeable)outStream);
            }
            this.setBodyAndHeader(out, output.build());
        }
        catch (Throwable e) {
            exchange.setOut(null);
            throw e;
        }
    }

    protected void setBodyAndHeader(Message out, Object encodedDataObject) {
        out.setBody(encodedDataObject);
    }

    protected abstract void marshalInternal(InputStream var1, OutputStream var2, Exchange var3) throws Exception;
}

